/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.starter.core;

import java.util.Objects;
import javax.annotation.Nullable;
import me.ahoo.pigeon.core.connector.ConnectorId;
import me.ahoo.pigeon.core.id.impl.MillisecondSnowflakeId;
import me.ahoo.pigeon.core.id.impl.MillisecondSnowflakeIdStateParser;
import me.ahoo.pigeon.core.id.impl.SafeJavaScriptSnowflakeId;
import me.ahoo.pigeon.core.id.impl.SecondSnowflakeId;
import me.ahoo.pigeon.core.id.impl.SecondSnowflakeIdStateParser;
import me.ahoo.pigeon.core.id.impl.SnowflakeId;
import me.ahoo.pigeon.starter.core.IdProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={IdProperties.class})
public class CoreAutoConfiguration {
    @Primary
    @Bean
    @ConditionalOnMissingBean
    public MillisecondSnowflakeId idGenerator(@Nullable IdProperties idProperties, @Nullable ConnectorId connectorId) {
        Integer machineId = this.getMachineId(idProperties, connectorId);
        return new MillisecondSnowflakeId(machineId.intValue());
    }

    @Bean
    @ConditionalOnBean(value={MillisecondSnowflakeId.class})
    public MillisecondSnowflakeIdStateParser millisecondSnowflakeIdStateParser(MillisecondSnowflakeId millisecondSnowflakeId) {
        return MillisecondSnowflakeIdStateParser.of((SnowflakeId)millisecondSnowflakeId);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecondSnowflakeId safeJavaScriptSecondSnowflakeId(@Nullable IdProperties idProperties, @Nullable ConnectorId connectorId) {
        Integer machineId = this.getMachineId(idProperties, connectorId);
        return SafeJavaScriptSnowflakeId.ofSecond((int)machineId);
    }

    @Bean
    @ConditionalOnBean(value={SecondSnowflakeId.class})
    public SecondSnowflakeIdStateParser secondSnowflakeIdStateParser(SecondSnowflakeId millisecondSnowflakeId) {
        return SecondSnowflakeIdStateParser.of((SnowflakeId)millisecondSnowflakeId);
    }

    private Integer getMachineId(@Nullable IdProperties idProperties, @Nullable ConnectorId connectorId) {
        Integer machineId = 1;
        if (Objects.nonNull(idProperties) && Objects.nonNull(idProperties.getSnowflake())) {
            machineId = idProperties.getSnowflake().getMachineId();
        } else if (Objects.nonNull(connectorId)) {
            machineId = connectorId.getId();
        }
        return machineId;
    }
}

