/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.starter.relation;

import me.ahoo.pigeon.core.relation.ConnectorUserRelationService;
import me.ahoo.pigeon.core.relation.DeviceConnectorRelationService;
import me.ahoo.pigeon.core.relation.GroupUserRelationService;
import me.ahoo.pigeon.core.relation.RoomConnectorRelationService;
import me.ahoo.pigeon.core.relation.UserConnectorRelationService;
import me.ahoo.pigeon.core.relation.none.NoneConnectorUserRelationService;
import me.ahoo.pigeon.core.relation.none.NoneDeviceConnectorRelationService;
import me.ahoo.pigeon.core.relation.none.NoneGroupUserRelationService;
import me.ahoo.pigeon.core.relation.none.NoneRoomConnectorRelationService;
import me.ahoo.pigeon.core.relation.none.NoneUserConnectorRelationService;
import me.ahoo.pigeon.relation.redis.RedisConnectorUserRelationService;
import me.ahoo.pigeon.relation.redis.RedisDeviceConnectorRelationService;
import me.ahoo.pigeon.relation.redis.RedisGroupUserRelationService;
import me.ahoo.pigeon.relation.redis.RedisRoomConnectorRelationService;
import me.ahoo.pigeon.relation.redis.RedisUserConnectorRelationService;
import me.ahoo.pigeon.relation.redis.StringIntegerRedisTemplate;
import me.ahoo.pigeon.relation.redis.StringLongRedisTemplate;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration(proxyBeanMethods=false)
public class RelationAutoConfiguration {

    @AutoConfigureAfter(value={RedisAutoConfiguration.class})
    @ConditionalOnClass(value={RedisConnectorUserRelationService.class})
    public static class Redis {
        @Bean
        @ConditionalOnMissingBean
        public StringIntegerRedisTemplate stringIntegerRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
            StringIntegerRedisTemplate template = new StringIntegerRedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }

        @Bean
        @ConditionalOnMissingBean
        public StringLongRedisTemplate stringLongRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
            StringLongRedisTemplate template = new StringLongRedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }

        @Bean
        @ConditionalOnMissingBean
        public ConnectorUserRelationService connectorUserRelationService(StringLongRedisTemplate redisTemplate) {
            return new RedisConnectorUserRelationService(redisTemplate);
        }

        @Bean
        @ConditionalOnMissingBean
        public DeviceConnectorRelationService deviceConnectorRelationService(StringIntegerRedisTemplate redisTemplate) {
            return new RedisDeviceConnectorRelationService(redisTemplate);
        }

        @Bean
        @ConditionalOnMissingBean
        public GroupUserRelationService groupUserRelationService(StringLongRedisTemplate redisTemplate) {
            return new RedisGroupUserRelationService(redisTemplate);
        }

        @Bean
        @ConditionalOnMissingBean
        public RoomConnectorRelationService roomConnectorRelationService(StringIntegerRedisTemplate redisTemplate) {
            return new RedisRoomConnectorRelationService(redisTemplate);
        }

        @Bean
        @ConditionalOnMissingBean
        public UserConnectorRelationService userConnectorRelationService(StringIntegerRedisTemplate redisTemplate) {
            return new RedisUserConnectorRelationService(redisTemplate);
        }
    }

    @ConditionalOnMissingClass(value={"me.ahoo.pigeon.relation.redis.RedisConnectorUserRelationService"})
    public static class None {
        @Bean
        @ConditionalOnMissingBean
        public ConnectorUserRelationService connectorUserRelationService() {
            return new NoneConnectorUserRelationService();
        }

        @Bean
        @ConditionalOnMissingBean
        public DeviceConnectorRelationService deviceConnectorRelationService() {
            return new NoneDeviceConnectorRelationService();
        }

        @Bean
        @ConditionalOnMissingBean
        public GroupUserRelationService groupUserRelationService() {
            return new NoneGroupUserRelationService();
        }

        @Bean
        @ConditionalOnMissingBean
        public RoomConnectorRelationService roomConnectorRelationService() {
            return new NoneRoomConnectorRelationService();
        }

        @Bean
        @ConditionalOnMissingBean
        public UserConnectorRelationService userConnectorRelationService() {
            return new NoneUserConnectorRelationService();
        }
    }
}

