/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.starter.security;

import java.util.List;
import java.util.Objects;
import me.ahoo.pigeon.core.id.IdGenerator;
import me.ahoo.pigeon.core.id.impl.SecondSnowflakeId;
import me.ahoo.pigeon.core.security.authorization.AuthorizationSupport;
import me.ahoo.pigeon.core.security.authorization.CompositeAuthorization;
import me.ahoo.pigeon.core.security.authorization.DeviceAuthorization;
import me.ahoo.pigeon.core.security.authorization.RoomAuthorization;
import me.ahoo.pigeon.core.security.authorization.UserAuthorization;
import me.ahoo.pigeon.core.security.authorization.jwt.JwtDeviceAuthorization;
import me.ahoo.pigeon.core.security.authorization.jwt.JwtRoomAuthorization;
import me.ahoo.pigeon.core.security.authorization.jwt.JwtUserAuthorization;
import me.ahoo.pigeon.core.security.authorization.none.NoneDeviceAuthorization;
import me.ahoo.pigeon.core.security.authorization.none.NoneRoomAuthorization;
import me.ahoo.pigeon.core.security.authorization.none.NoneUserAuthorization;
import me.ahoo.pigeon.core.security.command.CommandAuthorization;
import me.ahoo.pigeon.core.security.command.PrivilegeCommandAuthorization;
import me.ahoo.pigeon.core.security.command.TrueCommandAuthorization;
import me.ahoo.pigeon.core.security.command.privilege.PrivilegeChecker;
import me.ahoo.pigeon.core.security.command.privilege.PrivilegeSecurityChecker;
import me.ahoo.pigeon.core.security.command.privilege.config.CommandSecurity;
import me.ahoo.pigeon.core.security.device.DeviceRegistrar;
import me.ahoo.pigeon.core.security.device.TemporaryDeviceRegistrar;
import me.ahoo.pigeon.starter.security.SecurityProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SecurityProperties.class})
public class SecurityAutoConfiguration {
    private final SecurityProperties securityProperties;

    public SecurityAutoConfiguration(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandAuthorization privilegeCommandAuthorization() {
        CommandSecurity commandSecurity = this.securityProperties.getCommand();
        if (Objects.isNull(commandSecurity)) {
            return TrueCommandAuthorization.INSTANCE;
        }
        PrivilegeSecurityChecker privilegeSecurityChecker = commandSecurity.asPrivilegeSecurityChecker();
        return new PrivilegeCommandAuthorization((PrivilegeChecker)privilegeSecurityChecker);
    }

    @Bean
    @ConditionalOnBean(value={AuthorizationSupport.class})
    @ConditionalOnMissingBean
    public CompositeAuthorization compositeAuthorization(List<AuthorizationSupport> delegates) {
        return new CompositeAuthorization(delegates);
    }

    @Bean
    @ConditionalOnMissingBean
    public DeviceRegistrar deviceRegistrar(SecondSnowflakeId secondSnowflakeId) {
        return new TemporaryDeviceRegistrar(secondSnowflakeId);
    }

    @ConditionalOnProperty(prefix="pigeon.security", name={"auth.none"})
    public static class NoneAuth {
        @Bean
        @ConditionalOnMissingBean
        public UserAuthorization userAuthorization(IdGenerator idGenerator) {
            return new NoneUserAuthorization(idGenerator);
        }

        @Bean
        @ConditionalOnMissingBean
        public DeviceAuthorization deviceAuthorization(DeviceRegistrar deviceRegistrar) {
            return new NoneDeviceAuthorization(deviceRegistrar);
        }

        @Bean
        @ConditionalOnMissingBean
        public RoomAuthorization roomAuthorization() {
            return new NoneRoomAuthorization();
        }
    }

    public class JwtAuth {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="pigeon.security", name={"auth.jwt.user.alg-name"})
        public UserAuthorization userAuthorization() {
            return new JwtUserAuthorization(SecurityAutoConfiguration.this.securityProperties.getAuth().getJwt().getUser());
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="pigeon.security", name={"auth.jwt.device.alg-name"})
        public DeviceAuthorization deviceAuthorization(DeviceRegistrar deviceRegistrar) {
            return new JwtDeviceAuthorization(deviceRegistrar, SecurityAutoConfiguration.this.securityProperties.getAuth().getJwt().getDevice());
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="pigeon.security", name={"auth.jwt.room.alg-name"})
        public RoomAuthorization roomAuthorization() {
            return new JwtRoomAuthorization(SecurityAutoConfiguration.this.securityProperties.getAuth().getJwt().getRoom());
        }
    }
}

