/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.simba.core.AbstractMutexContender;
import me.ahoo.simba.core.MutexContendService;
import me.ahoo.simba.core.MutexContender;
import me.ahoo.simba.core.MutexOwner;
import me.ahoo.simba.core.MutexState;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\bH\u0017J\b\u0010\n\u001a\u00020\bH\u0017J\b\u0010\u000b\u001a\u00020\bH\u0017\u00a8\u0006\r"}, d2={"Lme/ahoo/simba/test/MutexContendServiceSpec;", "", "()V", "createMutexContendService", "Lme/ahoo/simba/core/MutexContendService;", "contender", "Lme/ahoo/simba/core/MutexContender;", "guard", "", "multiContend", "restart", "start", "Companion", "simba-test"})
public abstract class MutexContendServiceSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(MutexContendServiceSpec.class);
    @NotNull
    public static final String START_MUTEX = "start";
    @NotNull
    public static final String RESTART_MUTEX = "restart";
    @NotNull
    public static final String GUARD_MUTEX = "guard";
    @NotNull
    public static final String MULTI_CONTEND_MUTEX = "multiContend";

    @NotNull
    public abstract MutexContendService createMutexContendService(@NotNull MutexContender var1);

    @Test
    public void start() {
        CompletableFuture<MutexOwner> acquiredFuture = new CompletableFuture<MutexOwner>();
        CompletableFuture<MutexOwner> releasedFuture = new CompletableFuture<MutexOwner>();
        MutexContendService contendService2 = this.createMutexContendService((MutexContender)new AbstractMutexContender(acquiredFuture, releasedFuture){
            final /* synthetic */ CompletableFuture<MutexOwner> $acquiredFuture;
            final /* synthetic */ CompletableFuture<MutexOwner> $releasedFuture;
            {
                this.$acquiredFuture = $acquiredFuture;
                this.$releasedFuture = $releasedFuture;
                super("start", null, 2, null);
            }

            public void onAcquired(@NotNull MutexState mutexState) {
                Intrinsics.checkNotNullParameter((Object)mutexState, (String)"mutexState");
                MutexContendServiceSpec.access$getLog$cp().info("onAcquired");
                this.$acquiredFuture.complete(mutexState.getAfter());
            }

            public void onReleased(@NotNull MutexState mutexState) {
                Intrinsics.checkNotNullParameter((Object)mutexState, (String)"mutexState");
                MutexContendServiceSpec.access$getLog$cp().info("onReleased");
                this.$releasedFuture.complete(mutexState.getAfter());
            }
        });
        contendService2.start();
        acquiredFuture.join();
        MatcherAssert.assertThat((Object)contendService2.isOwner(), (Matcher)Matchers.equalTo((Object)true));
        contendService2.stop();
        releasedFuture.join();
        MatcherAssert.assertThat((Object)contendService2.isOwner(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void restart() {
        CompletableFuture<MutexOwner> acquiredFuture = new CompletableFuture<MutexOwner>();
        CompletableFuture<MutexOwner> releasedFuture = new CompletableFuture<MutexOwner>();
        CompletableFuture<MutexOwner> acquiredFuture2 = new CompletableFuture<MutexOwner>();
        CompletableFuture<MutexOwner> releasedFuture2 = new CompletableFuture<MutexOwner>();
        MutexContendService contendService2 = this.createMutexContendService((MutexContender)new AbstractMutexContender(acquiredFuture, acquiredFuture2, releasedFuture, releasedFuture2){
            final /* synthetic */ CompletableFuture<MutexOwner> $acquiredFuture;
            final /* synthetic */ CompletableFuture<MutexOwner> $acquiredFuture2;
            final /* synthetic */ CompletableFuture<MutexOwner> $releasedFuture;
            final /* synthetic */ CompletableFuture<MutexOwner> $releasedFuture2;
            {
                this.$acquiredFuture = $acquiredFuture;
                this.$acquiredFuture2 = $acquiredFuture2;
                this.$releasedFuture = $releasedFuture;
                this.$releasedFuture2 = $releasedFuture2;
                super("restart", null, 2, null);
            }

            public void onAcquired(@NotNull MutexState mutexState) {
                Intrinsics.checkNotNullParameter((Object)mutexState, (String)"mutexState");
                MutexContendServiceSpec.access$getLog$cp().info("onAcquired");
                if (!this.$acquiredFuture.isDone()) {
                    this.$acquiredFuture.complete(mutexState.getAfter());
                } else {
                    this.$acquiredFuture2.complete(mutexState.getAfter());
                }
            }

            public void onReleased(@NotNull MutexState mutexState) {
                Intrinsics.checkNotNullParameter((Object)mutexState, (String)"mutexState");
                MutexContendServiceSpec.access$getLog$cp().info("onReleased");
                if (!this.$releasedFuture.isDone()) {
                    this.$releasedFuture.complete(mutexState.getAfter());
                } else {
                    this.$releasedFuture2.complete(mutexState.getAfter());
                }
            }
        });
        contendService2.start();
        acquiredFuture.join();
        MatcherAssert.assertThat((Object)contendService2.isOwner(), (Matcher)Matchers.equalTo((Object)true));
        contendService2.stop();
        releasedFuture.join();
        MatcherAssert.assertThat((Object)contendService2.isOwner(), (Matcher)Matchers.equalTo((Object)false));
        contendService2.start();
        acquiredFuture2.join();
        MatcherAssert.assertThat((Object)contendService2.isOwner(), (Matcher)Matchers.equalTo((Object)true));
        contendService2.stop();
        releasedFuture2.join();
        MatcherAssert.assertThat((Object)contendService2.isOwner(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void guard() {
        CompletableFuture<MutexOwner> acquiredFuture = new CompletableFuture<MutexOwner>();
        CompletableFuture<MutexOwner> releasedFuture = new CompletableFuture<MutexOwner>();
        MutexContendService contendService2 = this.createMutexContendService((MutexContender)new AbstractMutexContender(acquiredFuture, releasedFuture){
            final /* synthetic */ CompletableFuture<MutexOwner> $acquiredFuture;
            final /* synthetic */ CompletableFuture<MutexOwner> $releasedFuture;
            {
                this.$acquiredFuture = $acquiredFuture;
                this.$releasedFuture = $releasedFuture;
                super("guard", null, 2, null);
            }

            public void onAcquired(@NotNull MutexState mutexState) {
                Intrinsics.checkNotNullParameter((Object)mutexState, (String)"mutexState");
                MutexContendServiceSpec.access$getLog$cp().info("onAcquired");
                this.$acquiredFuture.complete(mutexState.getAfter());
            }

            public void onReleased(@NotNull MutexState mutexState) {
                Intrinsics.checkNotNullParameter((Object)mutexState, (String)"mutexState");
                MutexContendServiceSpec.access$getLog$cp().info("onReleased");
                this.$releasedFuture.complete(mutexState.getAfter());
            }
        });
        contendService2.start();
        acquiredFuture.join();
        MatcherAssert.assertThat((Object)contendService2.isOwner(), (Matcher)Matchers.equalTo((Object)true));
        TimeUnit.SECONDS.sleep(3L);
        MatcherAssert.assertThat((Object)contendService2.getAfterOwner().getOwnerId(), (Matcher)Matchers.equalTo((Object)contendService2.getContender().getContenderId()));
        MatcherAssert.assertThat((Object)contendService2.isOwner(), (Matcher)Matchers.equalTo((Object)true));
        contendService2.stop();
        releasedFuture.join();
        MatcherAssert.assertThat((Object)contendService2.isOwner(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void multiContend() {
        int n;
        AtomicInteger count = new AtomicInteger(0);
        AtomicReference<String> currentOwnerIdRef = new AtomicReference<String>();
        List contendServiceList = new ArrayList(10);
        for (int i = 0; i < 10; ++i) {
            MutexContendService contendService2 = this.createMutexContendService((MutexContender)new AbstractMutexContender(currentOwnerIdRef, count){
                final /* synthetic */ AtomicReference<String> $currentOwnerIdRef;
                final /* synthetic */ AtomicInteger $count;
                {
                    this.$currentOwnerIdRef = $currentOwnerIdRef;
                    this.$count = $count;
                    super("multiContend", null, 2, null);
                }

                public void onAcquired(@NotNull MutexState mutexState) {
                    Intrinsics.checkNotNullParameter((Object)mutexState, (String)"mutexState");
                    this.$currentOwnerIdRef.set(mutexState.getAfter().getOwnerId());
                    super.onAcquired(mutexState);
                    MatcherAssert.assertThat((Object)this.$count.incrementAndGet(), (Matcher)Matchers.equalTo((Object)1));
                }

                public void onReleased(@NotNull MutexState mutexState) {
                    Intrinsics.checkNotNullParameter((Object)mutexState, (String)"mutexState");
                    super.onReleased(mutexState);
                    MatcherAssert.assertThat((Object)this.$count.decrementAndGet(), (Matcher)Matchers.equalTo((Object)0));
                }
            });
            contendService2.start();
            contendServiceList.add(contendService2);
        }
        TimeUnit.SECONDS.sleep(30L);
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.equalTo((Object)1));
        String currentOwnerId = currentOwnerIdRef.get();
        for (MutexContendService contendService3 : contendServiceList) {
            if (!(!StringsKt.isBlank((CharSequence)contendService3.getAfterOwner().getOwnerId()))) continue;
            MatcherAssert.assertThat((Object)contendService3.getAfterOwner().getOwnerId(), (Matcher)Matchers.equalTo((Object)currentOwnerId));
        }
        Iterable $this$count$iv = contendServiceList;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                MutexContendService it = (MutexContendService)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getContenderId(), (Object)currentOwnerId) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int ownerCount = n;
        MatcherAssert.assertThat((Object)ownerCount, (Matcher)Matchers.equalTo((Object)1));
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lme/ahoo/simba/test/MutexContendServiceSpec$Companion;", "", "()V", "GUARD_MUTEX", "", "MULTI_CONTEND_MUTEX", "RESTART_MUTEX", "START_MUTEX", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "simba-test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

