/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.api.annotation

/**
 * Annotation indicating that a class or method was auto-generated.
 * This annotation is used to mark elements in the code (such as classes, methods, etc.) that were generated by a tool or program,
 * rather than written manually. It can help developers quickly identify which parts of the code should not be modified manually,
 * to avoid conflicts when regenerating the code.
 *
 * @param value Specifies the name of the tool or program that generated the code. Default is an empty string.
 * @param date Specifies the date when the code was generated. Default is an empty string.
 */
annotation class Generated(
    val value: String = "",
    val date: String = "",
)
