/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.api.query;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import me.ahoo.wow.api.query.DeletionState;
import me.ahoo.wow.api.query.ICondition;
import me.ahoo.wow.api.query.Operator;
import me.ahoo.wow.api.query.RewritableCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u00013BK\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0011\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000H\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0016J\u0006\u0010\u001f\u001a\u00020 J\r\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u0004\u0018\u00010%J\b\u0010&\u001a\u0004\u0018\u00010'J\t\u0010(\u001a\u00020\u0004H\u00c6\u0003J\t\u0010)\u001a\u00020\u0006H\u00c6\u0003J\t\u0010*\u001a\u00020\bH\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u00c6\u0003J\u0015\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fH\u00c6\u0003JM\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fH\u00c6\u0001J\u0013\u0010.\u001a\u00020\"2\b\u0010/\u001a\u0004\u0018\u00010\bH\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\t\u00102\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00064"}, d2={"Lme/ahoo/wow/api/query/Condition;", "Lme/ahoo/wow/api/query/ICondition;", "Lme/ahoo/wow/api/query/RewritableCondition;", "field", "", "operator", "Lme/ahoo/wow/api/query/Operator;", "value", "", "children", "", "options", "", "<init>", "(Ljava/lang/String;Lme/ahoo/wow/api/query/Operator;Ljava/lang/Object;Ljava/util/List;Ljava/util/Map;)V", "getField", "()Ljava/lang/String;", "getOperator", "()Lme/ahoo/wow/api/query/Operator;", "getValue", "()Ljava/lang/Object;", "getChildren", "()Ljava/util/List;", "getOptions", "()Ljava/util/Map;", "valueAs", "V", "withCondition", "newCondition", "appendCondition", "append", "deletionState", "Lme/ahoo/wow/api/query/DeletionState;", "ignoreCase", "", "()Ljava/lang/Boolean;", "zoneId", "Ljava/time/ZoneId;", "datePattern", "Ljava/time/format/DateTimeFormatter;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "wow-api"})
public final class Condition
implements ICondition<Condition>,
RewritableCondition<Condition> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String field;
    @NotNull
    private final Operator operator;
    @NotNull
    private final Object value;
    @NotNull
    private final List<Condition> children;
    @NotNull
    private final Map<String, Object> options;
    @NotNull
    public static final String EMPTY_VALUE = "";
    @NotNull
    private static final Condition ALL = new Condition("", Operator.ALL, "", null, null, 24, null);
    @NotNull
    private static final Condition ACTIVE = Companion.deleted(DeletionState.ACTIVE);
    @NotNull
    public static final String IGNORE_CASE_OPTION_KEY = "ignoreCase";
    @NotNull
    public static final String ZONE_ID_OPTION_KEY = "zoneId";
    @NotNull
    public static final String DATE_PATTERN_OPTION_KEY = "datePattern";
    @NotNull
    private static final Map<String, Boolean> IGNORE_CASE_OPTIONS = MapsKt.mapOf((Pair)TuplesKt.to((Object)"ignoreCase", (Object)true));
    @NotNull
    private static final Map<String, Boolean> IGNORE_CASE_FALSE_OPTIONS = MapsKt.mapOf((Pair)TuplesKt.to((Object)"ignoreCase", (Object)false));

    public Condition(@NotNull String field, @NotNull Operator operator, @NotNull Object value, @NotNull List<Condition> children, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.field = field;
        this.operator = operator;
        this.value = value;
        this.children = children;
        this.options = options;
    }

    public /* synthetic */ Condition(String string, Operator operator, Object object, List list, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = EMPTY_VALUE;
        }
        if ((n & 2) != 0) {
            operator = Operator.ALL;
        }
        if ((n & 4) != 0) {
            object = EMPTY_VALUE;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, operator, object, list, map);
    }

    @Override
    @NotNull
    public String getField() {
        return this.field;
    }

    @Override
    @NotNull
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public List<Condition> getChildren() {
        return this.children;
    }

    @Override
    @NotNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    public final <V> V valueAs() {
        return (V)this.getValue();
    }

    @Override
    @NotNull
    public Condition withCondition(@NotNull Condition newCondition) {
        Intrinsics.checkNotNullParameter((Object)newCondition, (String)"newCondition");
        return newCondition;
    }

    @Override
    @NotNull
    public Condition appendCondition(@NotNull Condition append) {
        Intrinsics.checkNotNullParameter((Object)append, (String)"append");
        if (this.getOperator() == Operator.ALL) {
            return append;
        }
        Condition[] conditionArray = new Condition[]{this, append};
        return Companion.and(conditionArray);
    }

    @NotNull
    public final DeletionState deletionState() {
        if (!(this.getOperator() == Operator.DELETED)) {
            boolean $i$a$-require-Condition$deletionState$32 = false;
            String $i$a$-require-Condition$deletionState$32 = "Operator must be DELETED, but was " + this.getOperator() + ".";
            throw new IllegalArgumentException($i$a$-require-Condition$deletionState$32.toString());
        }
        if (this.getValue() instanceof DeletionState) {
            return (DeletionState)((Object)this.getValue());
        }
        if (this.getValue() instanceof Boolean) {
            return (Boolean)this.getValue() != false ? DeletionState.DELETED : DeletionState.ACTIVE;
        }
        if (!(this.getValue() instanceof String)) {
            boolean bl = false;
            String string = "Value must be String, Boolean, or DeletionState, but was " + Reflection.getOrCreateKotlinClass(this.getValue().getClass()).getSimpleName() + ".";
            throw new IllegalArgumentException(string.toString());
        }
        String string = ((String)this.getValue()).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return DeletionState.valueOf(string);
    }

    @Nullable
    public final Boolean ignoreCase() {
        Object object = this.getOptions().get(IGNORE_CASE_OPTION_KEY);
        return object instanceof Boolean ? (Boolean)object : null;
    }

    @Nullable
    public final ZoneId zoneId() {
        Object object = this.getOptions().get(ZONE_ID_OPTION_KEY);
        if (object == null) {
            return null;
        }
        Object zoneIdOptionValue = object;
        Object object2 = zoneIdOptionValue;
        return object2 instanceof String ? ZoneId.of((String)zoneIdOptionValue) : (object2 instanceof ZoneId ? (ZoneId)zoneIdOptionValue : null);
    }

    @Nullable
    public final DateTimeFormatter datePattern() {
        Object object = this.getOptions().get(DATE_PATTERN_OPTION_KEY);
        if (object == null) {
            return null;
        }
        Object datePatternOptionValue = object;
        Object object2 = datePatternOptionValue;
        return object2 instanceof String ? DateTimeFormatter.ofPattern((String)datePatternOptionValue) : (object2 instanceof DateTimeFormatter ? (DateTimeFormatter)datePatternOptionValue : null);
    }

    @NotNull
    public final String component1() {
        return this.field;
    }

    @NotNull
    public final Operator component2() {
        return this.operator;
    }

    @NotNull
    public final Object component3() {
        return this.value;
    }

    @NotNull
    public final List<Condition> component4() {
        return this.children;
    }

    @NotNull
    public final Map<String, Object> component5() {
        return this.options;
    }

    @NotNull
    public final Condition copy(@NotNull String field, @NotNull Operator operator, @NotNull Object value, @NotNull List<Condition> children, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return new Condition(field, operator, value, children, options);
    }

    public static /* synthetic */ Condition copy$default(Condition condition, String string, Operator operator, Object object, List list, Map map, int n, Object object2) {
        if ((n & 1) != 0) {
            string = condition.field;
        }
        if ((n & 2) != 0) {
            operator = condition.operator;
        }
        if ((n & 4) != 0) {
            object = condition.value;
        }
        if ((n & 8) != 0) {
            list = condition.children;
        }
        if ((n & 0x10) != 0) {
            map = condition.options;
        }
        return condition.copy(string, operator, object, list, map);
    }

    @NotNull
    public String toString() {
        return "Condition(field=" + this.field + ", operator=" + this.operator + ", value=" + this.value + ", children=" + this.children + ", options=" + this.options + ")";
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = result * 31 + this.operator.hashCode();
        result = result * 31 + this.value.hashCode();
        result = result * 31 + ((Object)this.children).hashCode();
        result = result * 31 + ((Object)this.options).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Condition)) {
            return false;
        }
        Condition condition = (Condition)other;
        if (!Intrinsics.areEqual((Object)this.field, (Object)condition.field)) {
            return false;
        }
        if (this.operator != condition.operator) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.value, (Object)condition.value)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.children, condition.children)) {
            return false;
        }
        return Intrinsics.areEqual(this.options, condition.options);
    }

    public Condition() {
        this(null, null, null, null, null, 31, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u0011J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001J\u001f\u0010\u0016\u001a\u00020\u00072\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0018\"\u00020\u0007\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u0016\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aJ\u001f\u0010\u001b\u001a\u00020\u00072\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0018\"\u00020\u0007\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u001b\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aJ\u001f\u0010\u001c\u001a\u00020\u00072\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0018\"\u00020\u0007\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u001c\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aJ\u0006\u0010\u001d\u001a\u00020\u0007J\u0006\u0010\u001e\u001a\u00020\u0007J\u0016\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0001J\u0016\u0010!\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0001J\u0016\u0010\"\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0001J\u0016\u0010#\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0001J\u0016\u0010$\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0001J\u0016\u0010%\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0001J \u0010&\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\u0011J \u0010(\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\u0011J \u0010)\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\u0011J\u001c\u0010*\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aJ\u001c\u0010+\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aJ)\u0010,\u001a\u00020\u0007\"\u0004\b\u0000\u0010-2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010.\u001a\u0002H-2\u0006\u0010/\u001a\u0002H-\u00a2\u0006\u0002\u00100J\u001c\u0010\u001d\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aJ\u0016\u00101\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u00102\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0005J\u000e\u00103\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0005J\u000e\u00104\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0005J\u000e\u00105\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0005J\u0018\u00106\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\b\b\u0002\u00106\u001a\u00020\u0011J\u000e\u00107\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0005J\u0014\u00108\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aJ\u001f\u00108\u001a\u00020\u00072\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0018\"\u00020\u0005\u00a2\u0006\u0002\u00109J\u000e\u0010:\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0005J\u0014\u0010;\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aJ\u001f\u0010;\u001a\u00020\u00072\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0018\"\u00020\u0005\u00a2\u0006\u0002\u00109J\u000e\u0010<\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010=\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010>\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010>\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020?J\u001a\u0010@\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u0001J\"\u0010B\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u00012\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u0001J\u001a\u0010D\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u0001J\u001a\u0010E\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u0001J\u001a\u0010F\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u0001J\u001a\u0010G\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u0001J\u001a\u0010H\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u0001J\u001a\u0010I\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u0001J\"\u0010J\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010K\u001a\u00020L2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u0001J\"\u0010M\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00052\u0006\u0010K\u001a\u00020L2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u0001J\u000e\u0010N\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lme/ahoo/wow/api/query/Condition$Companion;", "", "<init>", "()V", "EMPTY_VALUE", "", "ALL", "Lme/ahoo/wow/api/query/Condition;", "getALL", "()Lme/ahoo/wow/api/query/Condition;", "ACTIVE", "getACTIVE", "IGNORE_CASE_OPTION_KEY", "ZONE_ID_OPTION_KEY", "DATE_PATTERN_OPTION_KEY", "IGNORE_CASE_OPTIONS", "", "", "IGNORE_CASE_FALSE_OPTIONS", "ignoreCaseOptions", "value", "datePatternOptions", "and", "conditions", "", "([Lme/ahoo/wow/api/query/Condition;)Lme/ahoo/wow/api/query/Condition;", "", "or", "nor", "all", "active", "eq", "field", "ne", "gt", "lt", "gte", "lte", "contains", "ignoreCase", "startsWith", "endsWith", "isIn", "notIn", "between", "V", "start", "end", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Lme/ahoo/wow/api/query/Condition;", "elemMatch", "isNull", "notNull", "isTrue", "isFalse", "exists", "id", "ids", "([Ljava/lang/String;)Lme/ahoo/wow/api/query/Condition;", "aggregateId", "aggregateIds", "tenantId", "ownerId", "deleted", "Lme/ahoo/wow/api/query/DeletionState;", "today", "datePattern", "beforeToday", "time", "tomorrow", "thisWeek", "nextWeek", "lastWeek", "thisMonth", "lastMonth", "recentDays", "days", "", "earlierDays", "raw", "wow-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Condition getALL() {
            return ALL;
        }

        @NotNull
        public final Condition getACTIVE() {
            return ACTIVE;
        }

        @NotNull
        public final Map<String, Boolean> ignoreCaseOptions(boolean value) {
            return value ? IGNORE_CASE_OPTIONS : IGNORE_CASE_FALSE_OPTIONS;
        }

        @NotNull
        public final Map<String, Object> datePatternOptions(@Nullable Object value) {
            if (value == null) {
                return MapsKt.emptyMap();
            }
            if (!(value instanceof String || value instanceof DateTimeFormatter)) {
                boolean bl = false;
                String string = "datePatternOptions value must be String or DateTimeFormatter";
                throw new IllegalArgumentException(string.toString());
            }
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)Condition.DATE_PATTERN_OPTION_KEY, (Object)value));
        }

        @NotNull
        public final Condition and(Condition ... conditions) {
            Intrinsics.checkNotNullParameter((Object)conditions, (String)"conditions");
            return new Condition(Condition.EMPTY_VALUE, Operator.AND, null, ArraysKt.toList((Object[])conditions), null, 20, null);
        }

        @NotNull
        public final Condition and(@NotNull List<Condition> conditions) {
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            return new Condition(Condition.EMPTY_VALUE, Operator.AND, null, conditions, null, 20, null);
        }

        @NotNull
        public final Condition or(Condition ... conditions) {
            Intrinsics.checkNotNullParameter((Object)conditions, (String)"conditions");
            return new Condition(Condition.EMPTY_VALUE, Operator.OR, null, ArraysKt.toList((Object[])conditions), null, 20, null);
        }

        @NotNull
        public final Condition or(@NotNull List<Condition> conditions) {
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            return new Condition(Condition.EMPTY_VALUE, Operator.OR, null, conditions, null, 20, null);
        }

        @NotNull
        public final Condition nor(Condition ... conditions) {
            Intrinsics.checkNotNullParameter((Object)conditions, (String)"conditions");
            return new Condition(Condition.EMPTY_VALUE, Operator.NOR, null, ArraysKt.toList((Object[])conditions), null, 20, null);
        }

        @NotNull
        public final Condition nor(@NotNull List<Condition> conditions) {
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            return new Condition(Condition.EMPTY_VALUE, Operator.NOR, null, conditions, null, 20, null);
        }

        @NotNull
        public final Condition all() {
            return this.getALL();
        }

        @NotNull
        public final Condition active() {
            return this.getACTIVE();
        }

        @NotNull
        public final Condition eq(@NotNull String field, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(field, Operator.EQ, value, null, null, 24, null);
        }

        @NotNull
        public final Condition ne(@NotNull String field, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(field, Operator.NE, value, null, null, 24, null);
        }

        @NotNull
        public final Condition gt(@NotNull String field, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(field, Operator.GT, value, null, null, 24, null);
        }

        @NotNull
        public final Condition lt(@NotNull String field, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(field, Operator.LT, value, null, null, 24, null);
        }

        @NotNull
        public final Condition gte(@NotNull String field, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(field, Operator.GTE, value, null, null, 24, null);
        }

        @NotNull
        public final Condition lte(@NotNull String field, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(field, Operator.LTE, value, null, null, 24, null);
        }

        @NotNull
        public final Condition contains(@NotNull String field, @NotNull String value, boolean ignoreCase) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(field, Operator.CONTAINS, value, null, this.ignoreCaseOptions(ignoreCase), 8, null);
        }

        public static /* synthetic */ Condition contains$default(Companion companion, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.contains(string, string2, bl);
        }

        @NotNull
        public final Condition startsWith(@NotNull String field, @NotNull String value, boolean ignoreCase) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(field, Operator.STARTS_WITH, value, null, this.ignoreCaseOptions(ignoreCase), 8, null);
        }

        public static /* synthetic */ Condition startsWith$default(Companion companion, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.startsWith(string, string2, bl);
        }

        @NotNull
        public final Condition endsWith(@NotNull String field, @NotNull String value, boolean ignoreCase) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(field, Operator.ENDS_WITH, value, null, this.ignoreCaseOptions(ignoreCase), 8, null);
        }

        public static /* synthetic */ Condition endsWith$default(Companion companion, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.endsWith(string, string2, bl);
        }

        @NotNull
        public final Condition isIn(@NotNull String field, @NotNull List<? extends Object> value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return new Condition(field, Operator.IN, value, null, null, 24, null);
        }

        @NotNull
        public final Condition notIn(@NotNull String field, @NotNull List<? extends Object> value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return new Condition(field, Operator.NOT_IN, value, null, null, 24, null);
        }

        @NotNull
        public final <V> Condition between(@NotNull String field, V start, V end) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Object[] objectArray = new Object[]{start, end};
            return new Condition(field, Operator.BETWEEN, CollectionsKt.listOf((Object[])objectArray), null, null, 24, null);
        }

        @NotNull
        public final Condition all(@NotNull String field, @NotNull List<? extends Object> value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return new Condition(field, Operator.ALL_IN, value, null, null, 24, null);
        }

        @NotNull
        public final Condition elemMatch(@NotNull String field, @NotNull Condition value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(field, Operator.ELEM_MATCH, null, CollectionsKt.listOf((Object)value), null, 20, null);
        }

        @NotNull
        public final Condition isNull(@NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.NULL, null, null, null, 28, null);
        }

        @NotNull
        public final Condition notNull(@NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.NOT_NULL, null, null, null, 28, null);
        }

        @NotNull
        public final Condition isTrue(@NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.TRUE, null, null, null, 28, null);
        }

        @NotNull
        public final Condition isFalse(@NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.FALSE, null, null, null, 28, null);
        }

        @NotNull
        public final Condition exists(@NotNull String field, boolean exists) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.EXISTS, exists, null, null, 24, null);
        }

        public static /* synthetic */ Condition exists$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.exists(string, bl);
        }

        @NotNull
        public final Condition id(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(Condition.EMPTY_VALUE, Operator.ID, value, null, null, 24, null);
        }

        @NotNull
        public final Condition ids(@NotNull List<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return new Condition(Condition.EMPTY_VALUE, Operator.IDS, value, null, null, 24, null);
        }

        @NotNull
        public final Condition ids(String ... value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.ids(ArraysKt.asList((Object[])value));
        }

        @NotNull
        public final Condition aggregateId(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(Condition.EMPTY_VALUE, Operator.AGGREGATE_ID, value, null, null, 24, null);
        }

        @NotNull
        public final Condition aggregateIds(@NotNull List<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return new Condition(Condition.EMPTY_VALUE, Operator.AGGREGATE_IDS, value, null, null, 24, null);
        }

        @NotNull
        public final Condition aggregateIds(String ... value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.aggregateIds(ArraysKt.asList((Object[])value));
        }

        @NotNull
        public final Condition tenantId(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(Condition.EMPTY_VALUE, Operator.TENANT_ID, value, null, null, 24, null);
        }

        @NotNull
        public final Condition ownerId(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(Condition.EMPTY_VALUE, Operator.OWNER_ID, value, null, null, 24, null);
        }

        @NotNull
        public final Condition deleted(boolean value) {
            DeletionState deletionState = value ? DeletionState.DELETED : DeletionState.ACTIVE;
            return this.deleted(deletionState);
        }

        @NotNull
        public final Condition deleted(@NotNull DeletionState value) {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            return new Condition(Condition.EMPTY_VALUE, Operator.DELETED, (Object)value, null, null, 24, null);
        }

        @NotNull
        public final Condition today(@NotNull String field, @Nullable Object datePattern) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.TODAY, null, null, this.datePatternOptions(datePattern), 12, null);
        }

        public static /* synthetic */ Condition today$default(Companion companion, String string, Object object, int n, Object object2) {
            if ((n & 2) != 0) {
                object = null;
            }
            return companion.today(string, object);
        }

        @NotNull
        public final Condition beforeToday(@NotNull String field, @NotNull Object time, @Nullable Object datePattern) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            return new Condition(field, Operator.BEFORE_TODAY, time, null, this.datePatternOptions(datePattern), 8, null);
        }

        public static /* synthetic */ Condition beforeToday$default(Companion companion, String string, Object object, Object object2, int n, Object object3) {
            if ((n & 4) != 0) {
                object2 = null;
            }
            return companion.beforeToday(string, object, object2);
        }

        @NotNull
        public final Condition tomorrow(@NotNull String field, @Nullable Object datePattern) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.TOMORROW, null, null, this.datePatternOptions(datePattern), 12, null);
        }

        public static /* synthetic */ Condition tomorrow$default(Companion companion, String string, Object object, int n, Object object2) {
            if ((n & 2) != 0) {
                object = null;
            }
            return companion.tomorrow(string, object);
        }

        @NotNull
        public final Condition thisWeek(@NotNull String field, @Nullable Object datePattern) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.THIS_WEEK, null, null, this.datePatternOptions(datePattern), 12, null);
        }

        public static /* synthetic */ Condition thisWeek$default(Companion companion, String string, Object object, int n, Object object2) {
            if ((n & 2) != 0) {
                object = null;
            }
            return companion.thisWeek(string, object);
        }

        @NotNull
        public final Condition nextWeek(@NotNull String field, @Nullable Object datePattern) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.NEXT_WEEK, null, null, this.datePatternOptions(datePattern), 12, null);
        }

        public static /* synthetic */ Condition nextWeek$default(Companion companion, String string, Object object, int n, Object object2) {
            if ((n & 2) != 0) {
                object = null;
            }
            return companion.nextWeek(string, object);
        }

        @NotNull
        public final Condition lastWeek(@NotNull String field, @Nullable Object datePattern) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.LAST_WEEK, null, null, this.datePatternOptions(datePattern), 12, null);
        }

        public static /* synthetic */ Condition lastWeek$default(Companion companion, String string, Object object, int n, Object object2) {
            if ((n & 2) != 0) {
                object = null;
            }
            return companion.lastWeek(string, object);
        }

        @NotNull
        public final Condition thisMonth(@NotNull String field, @Nullable Object datePattern) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.THIS_MONTH, null, null, this.datePatternOptions(datePattern), 12, null);
        }

        public static /* synthetic */ Condition thisMonth$default(Companion companion, String string, Object object, int n, Object object2) {
            if ((n & 2) != 0) {
                object = null;
            }
            return companion.thisMonth(string, object);
        }

        @NotNull
        public final Condition lastMonth(@NotNull String field, @Nullable Object datePattern) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.LAST_MONTH, null, null, this.datePatternOptions(datePattern), 12, null);
        }

        public static /* synthetic */ Condition lastMonth$default(Companion companion, String string, Object object, int n, Object object2) {
            if ((n & 2) != 0) {
                object = null;
            }
            return companion.lastMonth(string, object);
        }

        @NotNull
        public final Condition recentDays(@NotNull String field, int days, @Nullable Object datePattern) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.RECENT_DAYS, days, null, this.datePatternOptions(datePattern), 8, null);
        }

        public static /* synthetic */ Condition recentDays$default(Companion companion, String string, int n, Object object, int n2, Object object2) {
            if ((n2 & 4) != 0) {
                object = null;
            }
            return companion.recentDays(string, n, object);
        }

        @NotNull
        public final Condition earlierDays(@NotNull String field, int days, @Nullable Object datePattern) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return new Condition(field, Operator.EARLIER_DAYS, days, null, this.datePatternOptions(datePattern), 8, null);
        }

        public static /* synthetic */ Condition earlierDays$default(Companion companion, String string, int n, Object object, int n2, Object object2) {
            if ((n2 & 4) != 0) {
                object = null;
            }
            return companion.earlierDays(string, n, object);
        }

        @NotNull
        public final Condition raw(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Condition(Condition.EMPTY_VALUE, Operator.RAW, value, null, null, 24, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

