/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.cache.refresh;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cache.DefaultCacheValue;
import me.ahoo.cache.TtlConfiguration;
import me.ahoo.cache.api.Cache;
import me.ahoo.cache.api.CacheValue;
import me.ahoo.wow.api.event.DomainEvent;
import me.ahoo.wow.api.messaging.function.FunctionKind;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.cache.StateToCacheDataConverter;
import me.ahoo.wow.cache.refresh.StateCacheRefresher;
import me.ahoo.wow.event.StateDomainEventExchange;
import me.ahoo.wow.modeling.state.ReadOnlyStateAggregate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u0003*\u0004\b\u0002\u0010\u00042\u00020\u00052 \u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00030\u00070\u0006Bs\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0011\u0012 \b\u0002\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001c\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00030\u0007H\u0016J\u001c\u0010$\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00030\u0007H\u0016R \u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000f\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR)\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lme/ahoo/wow/cache/refresh/SetStateCacheRefresher;", "K", "S", "", "D", "Lme/ahoo/cache/TtlConfiguration;", "Lme/ahoo/wow/cache/refresh/StateCacheRefresher;", "Lme/ahoo/wow/event/StateDomainEventExchange;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "stateToCacheDataConverter", "Lme/ahoo/wow/cache/StateToCacheDataConverter;", "Lme/ahoo/wow/modeling/state/ReadOnlyStateAggregate;", "ttl", "", "ttlAmplitude", "cache", "Lme/ahoo/cache/api/Cache;", "keyConvert", "Lkotlin/Function1;", "<init>", "(Lme/ahoo/wow/api/modeling/NamedAggregate;Lme/ahoo/wow/cache/StateToCacheDataConverter;JJLme/ahoo/cache/api/Cache;Lkotlin/jvm/functions/Function1;)V", "getTtl", "()J", "getTtlAmplitude", "getCache", "()Lme/ahoo/cache/api/Cache;", "getKeyConvert", "()Lkotlin/jvm/functions/Function1;", "functionKind", "Lme/ahoo/wow/api/messaging/function/FunctionKind;", "getFunctionKind", "()Lme/ahoo/wow/api/messaging/function/FunctionKind;", "evict", "", "exchange", "refresh", "wow-cocache"})
public class SetStateCacheRefresher<K, S, D>
extends StateCacheRefresher<S, D, StateDomainEventExchange<S, Object>>
implements TtlConfiguration {
    @NotNull
    private final StateToCacheDataConverter<ReadOnlyStateAggregate<S>, D> stateToCacheDataConverter;
    private final long ttl;
    private final long ttlAmplitude;
    @NotNull
    private final Cache<K, D> cache;
    @NotNull
    private final Function1<StateDomainEventExchange<S, Object>, K> keyConvert;
    @NotNull
    private final FunctionKind functionKind;

    public SetStateCacheRefresher(@NotNull NamedAggregate namedAggregate, @NotNull StateToCacheDataConverter<ReadOnlyStateAggregate<S>, D> stateToCacheDataConverter, long ttl, long ttlAmplitude, @NotNull Cache<K, D> cache, @NotNull Function1<? super StateDomainEventExchange<S, Object>, ? extends K> keyConvert) {
        Intrinsics.checkNotNullParameter((Object)namedAggregate, (String)"namedAggregate");
        Intrinsics.checkNotNullParameter(stateToCacheDataConverter, (String)"stateToCacheDataConverter");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        Intrinsics.checkNotNullParameter(keyConvert, (String)"keyConvert");
        super(namedAggregate);
        this.stateToCacheDataConverter = stateToCacheDataConverter;
        this.ttl = ttl;
        this.ttlAmplitude = ttlAmplitude;
        this.cache = cache;
        this.keyConvert = keyConvert;
        this.functionKind = FunctionKind.STATE_EVENT;
    }

    public /* synthetic */ SetStateCacheRefresher(NamedAggregate namedAggregate, StateToCacheDataConverter stateToCacheDataConverter, long l, long l2, Cache cache, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = Long.MAX_VALUE;
        }
        if ((n & 8) != 0) {
            l2 = 10L;
        }
        if ((n & 0x20) != 0) {
            function1 = SetStateCacheRefresher::_init_$lambda$0;
        }
        this(namedAggregate, stateToCacheDataConverter, l, l2, cache, function1);
    }

    public long getTtl() {
        return this.ttl;
    }

    public long getTtlAmplitude() {
        return this.ttlAmplitude;
    }

    @NotNull
    public final Cache<K, D> getCache() {
        return this.cache;
    }

    @NotNull
    public final Function1<StateDomainEventExchange<S, Object>, K> getKeyConvert() {
        return this.keyConvert;
    }

    @NotNull
    public FunctionKind getFunctionKind() {
        return this.functionKind;
    }

    public void evict(@NotNull StateDomainEventExchange<S, Object> exchange) {
        Intrinsics.checkNotNullParameter(exchange, (String)"exchange");
        Object key = this.keyConvert.invoke(exchange);
        this.cache.evict(key);
    }

    @Override
    public void refresh(@NotNull StateDomainEventExchange<S, Object> exchange) {
        Intrinsics.checkNotNullParameter(exchange, (String)"exchange");
        if (exchange.getState().getDeleted()) {
            this.evict(exchange);
            return;
        }
        Object key = this.keyConvert.invoke(exchange);
        D cacheData = this.stateToCacheDataConverter.stateToCacheData(exchange.getState());
        CacheValue cacheValue = DefaultCacheValue.Companion.ttlAt(cacheData, this.getTtl(), this.getTtlAmplitude());
        this.cache.setCache(key, cacheValue);
    }

    private static final Object _init_$lambda$0(StateDomainEventExchange exchange) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        return ((DomainEvent)exchange.getMessage()).getAggregateId().getId();
    }
}

