/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.compensation.domain;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.annotation.AggregateRoot;
import me.ahoo.wow.api.annotation.OnCommand;
import me.ahoo.wow.api.messaging.function.FunctionInfo;
import me.ahoo.wow.api.messaging.function.FunctionKind;
import me.ahoo.wow.compensation.api.ApplyExecutionFailed;
import me.ahoo.wow.compensation.api.ApplyExecutionSuccess;
import me.ahoo.wow.compensation.api.ApplyRetrySpec;
import me.ahoo.wow.compensation.api.ChangeFunction;
import me.ahoo.wow.compensation.api.CompensationPrepared;
import me.ahoo.wow.compensation.api.CreateExecutionFailed;
import me.ahoo.wow.compensation.api.ExecutionFailedApplied;
import me.ahoo.wow.compensation.api.ExecutionFailedCreated;
import me.ahoo.wow.compensation.api.ExecutionFailedStatus;
import me.ahoo.wow.compensation.api.ExecutionSuccessApplied;
import me.ahoo.wow.compensation.api.ForcePrepareCompensation;
import me.ahoo.wow.compensation.api.FunctionChanged;
import me.ahoo.wow.compensation.api.IRetrySpec;
import me.ahoo.wow.compensation.api.MarkRecoverable;
import me.ahoo.wow.compensation.api.PrepareCompensation;
import me.ahoo.wow.compensation.api.RecoverableMarked;
import me.ahoo.wow.compensation.api.RetrySpec;
import me.ahoo.wow.compensation.api.RetrySpecApplied;
import me.ahoo.wow.compensation.api.RetryState;
import me.ahoo.wow.compensation.domain.ExecutionFailedState;
import me.ahoo.wow.compensation.domain.NextRetryAtCalculator;
import org.jetbrains.annotations.NotNull;

@AggregateRoot
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020#H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lme/ahoo/wow/compensation/domain/ExecutionFailed;", "", "state", "Lme/ahoo/wow/compensation/domain/ExecutionFailedState;", "<init>", "(Lme/ahoo/wow/compensation/domain/ExecutionFailedState;)V", "onCreate", "Lme/ahoo/wow/compensation/api/ExecutionFailedCreated;", "command", "Lme/ahoo/wow/compensation/api/CreateExecutionFailed;", "retrySpec", "Lme/ahoo/wow/compensation/api/IRetrySpec;", "nextRetryAtCalculator", "Lme/ahoo/wow/compensation/domain/NextRetryAtCalculator;", "onPrepare", "Lme/ahoo/wow/compensation/api/CompensationPrepared;", "Lme/ahoo/wow/compensation/api/PrepareCompensation;", "onForcePrepare", "Lme/ahoo/wow/compensation/api/ForcePrepareCompensation;", "compensationPrepared", "onFailed", "Lme/ahoo/wow/compensation/api/ExecutionFailedApplied;", "Lme/ahoo/wow/compensation/api/ApplyExecutionFailed;", "onSucceed", "Lme/ahoo/wow/compensation/api/ExecutionSuccessApplied;", "Lme/ahoo/wow/compensation/api/ApplyExecutionSuccess;", "onApplyRetrySpec", "Lme/ahoo/wow/compensation/api/RetrySpecApplied;", "applyRetrySpec", "Lme/ahoo/wow/compensation/api/ApplyRetrySpec;", "onMarkRecoverable", "Lme/ahoo/wow/compensation/api/RecoverableMarked;", "Lme/ahoo/wow/compensation/api/MarkRecoverable;", "onChangeFunctionKind", "Lme/ahoo/wow/compensation/api/FunctionChanged;", "Lme/ahoo/wow/compensation/api/ChangeFunction;", "wow-compensation-domain"})
@SourceDebugExtension(value={"SMAP\nExecutionFailed.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionFailed.kt\nme/ahoo/wow/compensation/domain/ExecutionFailed\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class ExecutionFailed {
    @NotNull
    private final ExecutionFailedState state;

    public ExecutionFailed(@NotNull ExecutionFailedState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @OnCommand
    @NotNull
    public final ExecutionFailedCreated onCreate(@NotNull CreateExecutionFailed command, @NotNull IRetrySpec retrySpec, @NotNull NextRetryAtCalculator nextRetryAtCalculator) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)retrySpec, (String)"retrySpec");
        Intrinsics.checkNotNullParameter((Object)nextRetryAtCalculator, (String)"nextRetryAtCalculator");
        RetryState retryState = nextRetryAtCalculator.nextRetryState(retrySpec, 0, command.getExecuteAt());
        RetrySpec retrySpec2 = command.getRetrySpec();
        if (retrySpec2 == null) {
            retrySpec2 = RetrySpec.Companion.materialize(retrySpec);
        }
        RetrySpec commandRetrySpec = retrySpec2;
        return new ExecutionFailedCreated(command.getEventId(), command.getFunction(), command.getError(), command.getExecuteAt(), retryState, commandRetrySpec, command.getRecoverable());
    }

    @OnCommand
    @NotNull
    public final CompensationPrepared onPrepare(@NotNull PrepareCompensation command, @NotNull NextRetryAtCalculator nextRetryAtCalculator) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)nextRetryAtCalculator, (String)"nextRetryAtCalculator");
        if (!this.state.canRetry()) {
            boolean bl = false;
            String string = "ExecutionFailed can not retry.";
            throw new IllegalStateException(string.toString());
        }
        return this.compensationPrepared(nextRetryAtCalculator);
    }

    @OnCommand
    @NotNull
    public final CompensationPrepared onForcePrepare(@NotNull ForcePrepareCompensation command, @NotNull NextRetryAtCalculator nextRetryAtCalculator) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)nextRetryAtCalculator, (String)"nextRetryAtCalculator");
        if (!this.state.canForceRetry()) {
            boolean bl = false;
            String string = "ExecutionFailed can not force retry.";
            throw new IllegalStateException(string.toString());
        }
        return this.compensationPrepared(nextRetryAtCalculator);
    }

    private final CompensationPrepared compensationPrepared(NextRetryAtCalculator nextRetryAtCalculator) {
        int retries = this.state.getRetryState().getRetries() + 1;
        RetryState retryState = NextRetryAtCalculator.nextRetryState$default(nextRetryAtCalculator, (IRetrySpec)this.state.getRetrySpec(), retries, 0L, 4, null);
        return new CompensationPrepared(this.state.getEventId(), this.state.getFunction(), retryState);
    }

    @OnCommand
    @NotNull
    public final ExecutionFailedApplied onFailed(@NotNull ApplyExecutionFailed command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!(this.state.getStatus() == ExecutionFailedStatus.PREPARED)) {
            boolean bl = false;
            String string = "ExecutionFailed is not prepared.";
            throw new IllegalStateException(string.toString());
        }
        return new ExecutionFailedApplied(command.getError(), command.getExecuteAt(), command.getRecoverable());
    }

    @OnCommand
    @NotNull
    public final ExecutionSuccessApplied onSucceed(@NotNull ApplyExecutionSuccess command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!(this.state.getStatus() == ExecutionFailedStatus.PREPARED)) {
            boolean bl = false;
            String string = "ExecutionFailed is not prepared.";
            throw new IllegalStateException(string.toString());
        }
        return new ExecutionSuccessApplied(command.getExecuteAt());
    }

    @OnCommand
    @NotNull
    public final RetrySpecApplied onApplyRetrySpec(@NotNull ApplyRetrySpec applyRetrySpec) {
        Intrinsics.checkNotNullParameter((Object)applyRetrySpec, (String)"applyRetrySpec");
        return new RetrySpecApplied(applyRetrySpec.getMaxRetries(), applyRetrySpec.getMinBackoff(), applyRetrySpec.getExecutionTimeout());
    }

    @OnCommand
    @NotNull
    public final RecoverableMarked onMarkRecoverable(@NotNull MarkRecoverable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!(this.state.getRecoverable() != command.getRecoverable())) {
            boolean bl = false;
            String string = "ExecutionFailed recoverable is already marked to " + this.state.getRecoverable() + ".";
            throw new IllegalArgumentException(string.toString());
        }
        return new RecoverableMarked(command.getRecoverable());
    }

    @OnCommand
    @NotNull
    public final FunctionChanged onChangeFunctionKind(@NotNull ChangeFunction command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!(!this.state.getFunction().isSameFunction((FunctionInfo)command))) {
            boolean bl = false;
            String string = "ExecutionFailed function is already changed to " + this.state.getFunction() + ".";
            throw new IllegalArgumentException(string.toString());
        }
        FunctionKind functionKind = command.getFunctionKind();
        String string = command.getContextName();
        String string2 = command.getProcessorName();
        String string3 = command.getName();
        return new FunctionChanged(string3, string2, string, functionKind);
    }
}

