/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.annotation

import java.lang.annotation.Inherited

@Target(AnnotationTarget.CLASS)
@Inherited
annotation class Component(
    /**
     * component name.
     */
    val value: String
)

object Components {

    /**
     * @see me.ahoo.wow.modeling.command.AggregateDispatcher
     */
    const val AGGREGATE_DISPATCHER = "AggregateDispatcher"

    /**
     * @see me.ahoo.wow.modeling.annotation.AggregateRoot
     */
    const val AGGREGATE_ROOT = "AggregateRoot"

    /**
     * @see me.ahoo.wow.modeling.command.AggregateProcessor
     */
    const val AGGREGATE_PROCESSOR = "AggregateProcessor"

    /**
     * @see me.ahoo.wow.query.annotation.ProjectionProcessor
     */
    const val PROJECTION_PROCESSOR = "ProjectionProcessor"

    /**
     * @see me.ahoo.wow.modeling.state.snapshot.SnapshotDispatcher
     */
    const val SNAPSHOT_DISPATCHER = "SnapshotDispatcher"

    /**
     * @see me.ahoo.wow.event.annotation.EventProcessor
     */
    const val EVENT_PROCESSOR = "EventProcessor"

    /**
     * @see me.ahoo.wow.query.annotation.QueryProcessor
     */
    const val QUERY_PROCESSOR = "QueryProcessor"

    /**
     * @see me.ahoo.wow.saga.annotation.StatelessSaga
     */
    const val STATELESS_SAGA = "StatelessSaga"
    const val UNDEFINED = "Undefined"
}
