/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.ahoo.wow.command

import me.ahoo.wow.command.wait.WaitStrategy
import me.ahoo.wow.messaging.handler.MessageExchange

/**
 * Command Exchange .
 *
 * @author ahoo wang
 */
interface CommandExchange<C : Any> : MessageExchange<CommandMessage<C>>

interface ClientCommandExchange<C : Any> : CommandExchange<C> {
    val waitStrategy: WaitStrategy
}

data class SimpleClientCommandExchange<C : Any>(
    override val message: CommandMessage<C>,
    override val waitStrategy: WaitStrategy
) : ClientCommandExchange<C>

interface ServerCommandExchange<C : Any> : CommandExchange<C>

data class SimpleServerCommandExchange<C : Any>(
    override val message: CommandMessage<C>
) : ServerCommandExchange<C>
