/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.command.wait

enum class CommandStage {
    /**
     * 当命令发布到命令总线/队列后，生成完成信号.
     */
    SENT,

    /**
     * 当命令被处理后，生成完成信号.
     */
    PROCESSED,

    /**
     * 当命令产生当事件已被投影时，生成完成信号.
     */
    PROJECTED;
}
