/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.ahoo.wow.event.annotation

import me.ahoo.wow.event.DomainEvent
import me.ahoo.wow.messaging.OnMessage
import java.lang.annotation.Inherited

const val DEFAULT_ON_EVENT_NAME = "onEvent"

/**
 * On Event .
 *
 * @author ahoo wang
 */
@Target(AnnotationTarget.FUNCTION)
@Inherited
@OnMessage(DomainEvent::class, DEFAULT_ON_EVENT_NAME)
annotation class OnEvent(
    /**
     * aggregate Names
     */
    vararg val value: String
)
