/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.event.serialization

import me.ahoo.wow.Identifier
import me.ahoo.wow.Version
import me.ahoo.wow.command.CommandId
import me.ahoo.wow.command.RequestId
import me.ahoo.wow.modeling.AggregateId

data class DomainEventStreamRecord(
    override val id: String,
    val aggregateId: AggregateId,
    override val commandId: String,
    override val requestId: String,
    override val version: Int,
    val header: String,
    val body: String,
    val createTime: Long
) : Identifier, RequestId, CommandId, Version
