/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.eventsourcing

import me.ahoo.wow.event.DomainEventStream
import me.ahoo.wow.exception.WowException
import me.ahoo.wow.exception.WowTransientException

object EventSourcingErrorCodes {
    private const val PREFIX = "ES-"
    const val EVENT_VERSION_CONFLICT = PREFIX + "409"
    const val REQUEST_ID_IDEMPOTENCY = PREFIX + "410"
}

class EventVersionConflictException(val eventStream: DomainEventStream, reason: String?) : WowTransientException(
    EventSourcingErrorCodes.EVENT_VERSION_CONFLICT,
    "[${eventStream.aggregateId}] version:[${eventStream.version}] version conflict - reason:[$reason]."
)

class RequestIdIdempotencyException(val eventStream: DomainEventStream) : WowException(
    EventSourcingErrorCodes.REQUEST_ID_IDEMPOTENCY,
    "[${eventStream.aggregateId}] requestId:[${eventStream.requestId}] duplicate."
)
