/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.id

import me.ahoo.cosid.cosid.ClockSyncCosIdGenerator
import me.ahoo.cosid.cosid.CosIdGenerator
import me.ahoo.cosid.cosid.Radix62CosIdGenerator
import me.ahoo.wow.modeling.NamedAggregate
import me.ahoo.wow.modeling.materialize
import org.slf4j.LoggerFactory
import java.util.concurrent.ConcurrentHashMap

private val AGGREGATE_ID_GENERATORS: MutableMap<NamedAggregate, CosIdGenerator> =
    ConcurrentHashMap<NamedAggregate, CosIdGenerator>()

object AggregateIdGeneratorRegistrar :
    Map<NamedAggregate, CosIdGenerator> by AGGREGATE_ID_GENERATORS {
    private val log = LoggerFactory.getLogger(AggregateIdGeneratorRegistrar::class.java)

    fun getOrInitialize(key: NamedAggregate): CosIdGenerator {
        return AGGREGATE_ID_GENERATORS.computeIfAbsent(key) {
            val idGenerator = Radix62CosIdGenerator(IdFactory.machineId)
            val clockSyncCosIdGenerator = ClockSyncCosIdGenerator(idGenerator)
            if (log.isInfoEnabled) {
                log.info("Initialize $clockSyncCosIdGenerator to $key.")
            }
            return@computeIfAbsent clockSyncCosIdGenerator
        }
    }

    fun generateId(key: NamedAggregate): String {
        return getOrInitialize(key).generateAsString()
    }
}

fun NamedAggregate.generateId(): String {
    return AggregateIdGeneratorRegistrar.generateId(materialize())
}
