/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.messaging

/**
 * Message Header .
 *
 * @author ahoo wang
 */
interface Header : Map<String, String> {
    fun mergeWith(additionalSource: Map<String, String>): Header

    companion object {
        @JvmField
        val EMPTY: Header = DefaultHeader()
    }
}

fun Map<String, String>?.asHeader(): Header {
    if (isNullOrEmpty()) {
        return Header.EMPTY
    }
    return if (this is Header) {
        this
    } else {
        DefaultHeader(this)
    }
}
