/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.messaging.serialization

import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.databind.DeserializationContext
import com.fasterxml.jackson.databind.JsonNode
import com.fasterxml.jackson.databind.deser.std.StdDeserializer
import me.ahoo.wow.infra.TypeNameMapper.asType
import me.ahoo.wow.query.QueryMessage
import me.ahoo.wow.query.SimpleQueryMessage

interface QueryRecord :
    NamedBoundedContextMessageRecord,
    MessageNameRecord,
    MessageBodyTypeRecord

class DelegatingQueryRecord(override val actual: JsonNode) : QueryRecord

fun JsonNode.asQueryRecord(): QueryRecord {
    return DelegatingQueryRecord(this)
}

object QueryJsonSerializer : MessageSerializer<QueryMessage<*>>(QueryMessage::class.java)

object QueryJsonDeserializer : StdDeserializer<QueryMessage<*>>(QueryMessage::class.java) {
    override fun deserialize(p: JsonParser, ctxt: DeserializationContext): QueryMessage<*> {
        val queryRecord = JsonSerializer.readTree<JsonNode>(p).asQueryRecord()
        val bodyType = queryRecord.bodyType.asType<Any>()
        return SimpleQueryMessage(
            id = queryRecord.id,
            header = queryRecord.header,
            body = queryRecord.body.asObject(bodyType),
            contextName = queryRecord.contextName,
            name = queryRecord.name,
            createTime = queryRecord.createTime
        )
    }
}
