/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.messaging.serialization

import com.fasterxml.jackson.databind.module.SimpleModule
import me.ahoo.wow.command.CommandMessage
import me.ahoo.wow.event.DomainEvent
import me.ahoo.wow.event.DomainEventStream
import me.ahoo.wow.eventsourcing.snapshot.Snapshot
import me.ahoo.wow.messaging.tracing.TracingMessage
import me.ahoo.wow.query.QueryMessage

class WowModule : SimpleModule() {
    init {
        addSerializer(TracingMessage::class.java, TracingJsonSerializer)
        addDeserializer(TracingMessage::class.java, TracingJsonDeserializer)

        addSerializer(QueryMessage::class.java, QueryJsonSerializer)
        addDeserializer(QueryMessage::class.java, QueryJsonDeserializer)

        addSerializer(CommandMessage::class.java, CommandJsonSerializer)
        addDeserializer(CommandMessage::class.java, CommandJsonDeserializer)

        addSerializer(DomainEventStream::class.java, EventStreamJsonSerializer)
        addDeserializer(DomainEventStream::class.java, EventStreamJsonDeserializer)

        addSerializer(DomainEvent::class.java, DomainEventJsonSerializer)
        addDeserializer(DomainEvent::class.java, DomainEventJsonDeserializer)

        addSerializer(Snapshot::class.java, SnapshotSerializer)
        addDeserializer(Snapshot::class.java, SnapshotDeserializer)
    }
}
