/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.ahoo.wow.messaging.tracing

import me.ahoo.wow.naming.NamedBoundedContext
import reactor.core.publisher.Flux
import reactor.core.publisher.Mono
import reactor.core.publisher.Sinks

class InMemoryTracingBus(
    private val sink: Sinks.Many<TracingMessage> = Sinks.many().multicast().onBackpressureBuffer()
) : TracingBus {

    override fun send(tracingMessage: TracingMessage): Mono<Void> {
        return Mono.fromRunnable {
            sink.emitNext(tracingMessage, Sinks.EmitFailureHandler.FAIL_FAST)
        }
    }

    override fun receive(namedBoundedContexts: Set<NamedBoundedContext>): Flux<TracingMessage> {
        return sink.asFlux()
            .filter { tracingMessage ->
                namedBoundedContexts.any {
                    it.isSameBoundedContext(tracingMessage)
                }
            }
    }
}
