/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.messaging.tracing

import me.ahoo.wow.messaging.Message
import reactor.core.publisher.Mono
import reactor.util.context.Context
import reactor.util.context.ContextView

const val UPSTREAM_MESSAGE = "(UpstreamMessage)"

/**
 * based on [reactor.util.context.Context]
 */
fun ContextView.getUpstream(): Message<*>? {
    return getOrDefault<Message<*>>(UPSTREAM_MESSAGE, null)
}

fun Context.setUpstream(upstreamMessage: Message<*>?): Context {
    if (upstreamMessage == null) {
        return this
    }
    return this.put(UPSTREAM_MESSAGE, upstreamMessage)
}

/**
 * Write trace upstream.
 */
fun <T> Mono<T>.writeUpstream(upstreamMessage: Message<*>?): Mono<T> {
    if (upstreamMessage == null) {
        return this
    }
    return contextWrite { it.setUpstream(upstreamMessage) }
}
