/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.modeling.command

import me.ahoo.wow.annotation.Component
import me.ahoo.wow.annotation.Components
import me.ahoo.wow.command.CommandMessage
import me.ahoo.wow.event.DomainEventStream
import me.ahoo.wow.messaging.processor.MonoMessageProcessor
import me.ahoo.wow.modeling.AggregateId
import me.ahoo.wow.modeling.NamedTypedAggregate
import reactor.core.publisher.Mono

@Component(Components.AGGREGATE_PROCESSOR)
interface AggregateProcessor<C : Any> :
    NamedTypedAggregate<C>,
    MonoMessageProcessor<C, CommandMessage<*>, Mono<DomainEventStream>> {
    val aggregateId: AggregateId

    /**
     * Processing of commands must be serial.
     */
    @Throws(IncompatibleVersionException::class)
    override fun process(message: CommandMessage<*>): Mono<DomainEventStream>
}
