/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.modeling.command

import me.ahoo.wow.annotation.Components
import me.ahoo.wow.annotation.ORDER_FIRST
import me.ahoo.wow.annotation.Order
import me.ahoo.wow.command.ServerCommandExchange
import me.ahoo.wow.messaging.handler.Filter
import me.ahoo.wow.messaging.handler.FilterChain
import me.ahoo.wow.messaging.handler.FilterType
import me.ahoo.wow.messaging.tracing.TracingGateway
import me.ahoo.wow.messaging.tracing.trace
import me.ahoo.wow.messaging.tracing.writeUpstream
import reactor.core.publisher.Mono

@FilterType(AggregateDispatcher::class)
@Order(ORDER_FIRST)
class TracingCommandFilter(
    private val tracingGateway: TracingGateway
) : Filter<ServerCommandExchange<Any>> {
    override fun filter(
        exchange: ServerCommandExchange<Any>,
        chain: FilterChain<ServerCommandExchange<Any>>
    ): Mono<Void> {
        val command = exchange.message
        return tracingGateway.trace(
            contextName = command.contextName,
            component = Components.AGGREGATE_PROCESSOR,
            name = "${command.aggregateName}.${command.name}",
            upstreamMessage = command
        ) {
            chain.filter(exchange).writeUpstream(it)
        }
    }
}
