/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.ahoo.wow.modeling.matedata

import me.ahoo.wow.command.CommandMessage
import me.ahoo.wow.infra.accessor.constructor.ConstructorAccessor
import me.ahoo.wow.messaging.function.MessageFunction
import me.ahoo.wow.messaging.function.MethodFunctionMetadata
import me.ahoo.wow.messaging.function.asMessageFunction
import me.ahoo.wow.metadata.Metadata
import me.ahoo.wow.modeling.NamedAggregate
import me.ahoo.wow.modeling.NamedAggregateDecorator
import me.ahoo.wow.modeling.NamedTypedAggregate
import reactor.core.publisher.Mono

data class CommandAggregateMetadata<C : Any>(
    override val aggregateType: Class<C>,
    override val namedAggregate: NamedAggregate,
    val constructorAccessor: ConstructorAccessor<C>,
    val commandFunctionRegistry: Map<Class<*>, MethodFunctionMetadata<C, Mono<*>>>
) : NamedTypedAggregate<C>, NamedAggregateDecorator, Metadata {

    fun asMessageFunctionRegistry(commandRoot: C): Map<Class<*>, MessageFunction<C, CommandMessage<*>, Mono<*>>> {
        return commandFunctionRegistry
            .map {
                it.key to it.value.asMessageFunction<C, CommandMessage<*>, Mono<*>>(commandRoot)
            }.toMap()
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is CommandAggregateMetadata<*>) return false

        if (aggregateType != other.aggregateType) return false

        return true
    }

    override fun hashCode(): Int {
        return aggregateType.hashCode()
    }

    override fun toString(): String {
        return "CommandAggregateMetadata(aggregateType=$aggregateType)"
    }
}
