/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.modeling.state

import me.ahoo.wow.event.DomainEventStream
import me.ahoo.wow.exception.WowException
import me.ahoo.wow.modeling.NamedAggregate

object StateAggregateErrorCodes {
    const val SOURCING_VERSION_CONFLICT = "MS-1"
    const val AGGREGATE_NOT_FOUND = "MS-404"
}

class SourcingVersionConflictException(
    val domainEventStream: DomainEventStream,
    val expectVersion: Int
) : WowException(
    StateAggregateErrorCodes.SOURCING_VERSION_CONFLICT,
    "DomainEventStream[${domainEventStream.id}] - ${domainEventStream.aggregateId} sourcing version conflict. ExpectVersion[$expectVersion] but actualVersion[${domainEventStream.version}]."
),
    NamedAggregate by domainEventStream
