/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.query

import me.ahoo.wow.messaging.MessageBus
import me.ahoo.wow.naming.NamedBoundedContext
import reactor.core.publisher.Flux
import reactor.core.publisher.Mono

/**
 * QueryBus .
 * 1. 负责将查询消息转发到查询处理器
 * 2. 查询总线不跨越应用边界（即不跨越应用网络）
 * 3. 查询方法需要返回视图结果
 *
 * @author ahoo wang
 */
interface QueryBus : MessageBus {
    fun <Q : Any, R : Any> send(queryMessage: QueryMessage<Q>): Mono<R>
    fun receive(namedBoundedContexts: Set<NamedBoundedContext>): Flux<QueryExchange<Any, Any>>
}
