/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.query

import me.ahoo.wow.messaging.dispatcher.AbstractMessageDispatcher
import me.ahoo.wow.messaging.dispatcher.HandledSignal
import me.ahoo.wow.naming.NamedBoundedContext
import reactor.core.scheduler.Scheduler
import reactor.core.scheduler.Schedulers

class QueryDispatcher(
    private val queryBus: QueryBus,
    private val functionRegistrar: QueryFunctionRegistrar,
    private val queryHandler: QueryHandler
) : AbstractMessageDispatcher<HandledSignal>() {

    override val name: String
        get() = "QueryDispatcher"
    override val topics: Set<NamedBoundedContext>
        get() = functionRegistrar.namedBoundedContexts
    private val scheduler: Scheduler = Schedulers.newParallel(name)

    override fun start() {
        queryBus
            .receive(topics)
            .parallel()
            .runOn(scheduler)
            .flatMap {
                queryHandler.handle(it).thenReturn(HandledSignal)
            }
            .subscribe(this)
    }
}
