/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.query

import me.ahoo.wow.messaging.handler.MessageExchange
import reactor.core.publisher.Mono
import reactor.core.publisher.Sinks

interface QueryExchange<Q : Any, R : Any> : MessageExchange<QueryMessage<Q>> {
    val result: Mono<R>
    fun failure(error: Throwable)
    fun success(result: R?)
}

class DefaultQueryExchange<Q : Any, R : Any>(override val message: QueryMessage<Q>) : QueryExchange<Q, R> {
    private val resultSink = Sinks.one<R>()
    override val result: Mono<R>
        get() = resultSink.asMono()

    override fun failure(error: Throwable) {
        resultSink.tryEmitError(error)
    }

    override fun success(result: R?) {
        if (result == null) resultSink.tryEmitEmpty() else resultSink.tryEmitValue(result)
    }
}
