/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.query

import me.ahoo.wow.annotation.ORDER_DEFAULT_STEP
import me.ahoo.wow.annotation.ORDER_FIRST
import me.ahoo.wow.annotation.Order
import me.ahoo.wow.messaging.function.MessageFunction
import me.ahoo.wow.messaging.handler.Filter
import me.ahoo.wow.messaging.handler.FilterChain
import me.ahoo.wow.messaging.handler.FilterType
import reactor.core.publisher.Mono

@FilterType(QueryDispatcher::class)
@Order(ORDER_FIRST + ORDER_DEFAULT_STEP)
class QueryFunctionMappingFilter(private val functionRegistrar: QueryFunctionRegistrar) :
    Filter<QueryExchange<Any, Any>> {
    override fun filter(exchange: QueryExchange<Any, Any>, chain: FilterChain<QueryExchange<Any, Any>>): Mono<Void> {
        return Mono.defer {
            val function = functionRegistrar.getFunction(exchange.message.body.javaClass)
            if (function == null) {
                val notFoundQueryHandler = NotFoundQueryHandler(exchange.message)
                exchange.failure(notFoundQueryHandler)
                return@defer Mono.empty()
            }

            chain.filter(exchange)
                .contextWrite {
                    it.put(MessageFunction::class.java, function)
                }
        }
    }
}
