/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.query

import me.ahoo.wow.id.IdFactory
import me.ahoo.wow.messaging.Header
import me.ahoo.wow.messaging.Message
import me.ahoo.wow.messaging.NamedMessage
import me.ahoo.wow.query.annotation.asQueryMetadata
import java.time.Clock

/**
 * Query Message .
 *
 * @author ahoo wang
 */
interface QueryMessage<out Q : Any> : NamedMessage<Q>

data class SimpleQueryMessage<out Q : Any>(
    override val id: String,
    override val header: Header,
    override val body: Q,
    override val createTime: Long = Clock.systemUTC().millis(),
    override val contextName: String,
    override val name: String
) : QueryMessage<Q> {
    override fun mergeHeader(additionalSource: Map<String, String>): Message<Q> =
        copy(header = header.mergeWith(additionalSource))
}

fun <Q : Any> Q.asQueryMessage(
    id: String = IdFactory.generateAsString(),
    header: Header = Header.EMPTY,
    createTime: Long = Clock.systemUTC().millis()
): QueryMessage<Q> {
    val metadata = javaClass.asQueryMetadata()
    return SimpleQueryMessage(
        id = id,
        header = header,
        body = this,
        createTime = createTime,
        contextName = metadata.contextName,
        name = metadata.name
    )
}
