/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.query.annotation

import me.ahoo.wow.configuration.asRequiredNamedBoundedContext
import me.ahoo.wow.infra.reflection.ClassMetadata
import me.ahoo.wow.infra.reflection.ClassVisitor
import me.ahoo.wow.metadata.CacheableMetadataParser
import me.ahoo.wow.naming.annotation.asName
import me.ahoo.wow.query.metadata.QueryMetadata

/**
 * QueryMetadataParser .
 *
 * @author ahoo wang
 */
object QueryMetadataParser : CacheableMetadataParser<QueryMetadata<*>>() {

    override fun parseAsMetadata(type: Class<*>): QueryMetadata<*> {
        val visitor = QueryMetadataVisitor(type)
        ClassMetadata.visit(type, visitor)
        return visitor.asMetadata()
    }
}

internal class QueryMetadataVisitor<Q>(private val queryType: Class<Q>) : ClassVisitor {
    private val queryName: String = queryType.asName()

    fun asMetadata(): QueryMetadata<Q> {
        return QueryMetadata(queryType, queryType.asRequiredNamedBoundedContext(), queryName)
    }
}

fun <Q> Class<Q>.asQueryMetadata(): QueryMetadata<Q> {
    @Suppress("UNCHECKED_CAST")
    return QueryMetadataParser.parse(this) as QueryMetadata<Q>
}

inline fun <reified Q> queryMetadata(): QueryMetadata<Q> {
    return Q::class.java.asQueryMetadata()
}
