/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.query.annotation

import me.ahoo.wow.messaging.processor.ProcessorMetadata
import me.ahoo.wow.messaging.processor.ProcessorMetadataParser
import me.ahoo.wow.query.QueryMessage

object QueryProcessorMetadataParser : ProcessorMetadataParser<OnQuery, QueryMessage<*>>(
    onMessageType = OnQuery::class.java,
    functionCondition = {
        it.parameterCount == 1
    }
)

fun <P : Any> Class<P>.asQueryProcessorMetadata(): ProcessorMetadata<P, QueryMessage<*>> {
    @Suppress("UNCHECKED_CAST")
    return QueryProcessorMetadataParser.parse(this) as ProcessorMetadata<P, QueryMessage<*>>
}

inline fun <reified P : Any> queryProcessorMetadata(): ProcessorMetadata<P, QueryMessage<*>> {
    return P::class.java.asQueryProcessorMetadata()
}
