/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.query.collector

import me.ahoo.wow.messaging.dispatcher.AbstractMessageDispatcher
import me.ahoo.wow.naming.NamedBoundedContext
import me.ahoo.wow.query.QueryBus
import me.ahoo.wow.query.QueryMessage
import reactor.core.scheduler.Schedulers

object AllLocalQuery : NamedBoundedContext {
    override val contextName: String
        get() = "ALL_LOCAL_QUERY"

    override fun isSameBoundedContext(other: NamedBoundedContext): Boolean {
        return true
    }

    override fun toString(): String {
        return contextName
    }
}

class QueryCollectorDispatcher(private val queryBus: QueryBus, private val queryCollector: QueryCollector) :
    AbstractMessageDispatcher<QueryMessage<*>>() {
    override val topics: Set<NamedBoundedContext> = setOf(AllLocalQuery)

    override fun start() {
        queryBus.receive(topics)
            .map {
                it.message
            }
            .publishOn(Schedulers.boundedElastic())
            .subscribe(this)
    }

    override val name: String
        get() = QueryCollectorDispatcher::class.java.simpleName

    override fun safeOnNext(value: QueryMessage<*>) {
        queryCollector.collect(value).subscribe()
    }
}
