/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.event.upgrader;

import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.annotation.OrderComparator;
import me.ahoo.wow.event.upgrader.EventNamedAggregate;
import me.ahoo.wow.event.upgrader.EventUpgrader;
import me.ahoo.wow.event.upgrader.MutableDomainEventRecord;
import me.ahoo.wow.modeling.MaterializedNamedAggregate;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.serialization.DomainEventRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lme/ahoo/wow/event/upgrader/EventUpgraderFactory;", "", "()V", "eventUpgraderFactories", "Ljava/util/concurrent/ConcurrentHashMap;", "Lme/ahoo/wow/event/upgrader/EventNamedAggregate;", "Ljava/util/SortedSet;", "Lme/ahoo/wow/event/upgrader/EventUpgrader;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "get", "", "eventNamedAggregate", "register", "", "eventUpgrader", "upgrade", "Lme/ahoo/wow/serialization/DomainEventRecord;", "domainEventRecord", "wow-core"})
@SourceDebugExtension(value={"SMAP\nEventUpgraderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventUpgraderFactory.kt\nme/ahoo/wow/event/upgrader/EventUpgraderFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1855#2,2:77\n1855#2,2:79\n*S KotlinDebug\n*F\n+ 1 EventUpgraderFactory.kt\nme/ahoo/wow/event/upgrader/EventUpgraderFactory\n*L\n67#1:77,2\n33#1:79,2\n*E\n"})
public final class EventUpgraderFactory {
    @NotNull
    public static final EventUpgraderFactory INSTANCE = new EventUpgraderFactory();
    private static final Logger log = LoggerFactory.getLogger(EventUpgraderFactory.class);
    @NotNull
    private static final ConcurrentHashMap<EventNamedAggregate, SortedSet<EventUpgrader>> eventUpgraderFactories = new ConcurrentHashMap();

    private EventUpgraderFactory() {
    }

    public final void register(@NotNull EventUpgrader eventUpgrader) {
        Intrinsics.checkNotNullParameter((Object)eventUpgrader, (String)"eventUpgrader");
        if (log.isInfoEnabled()) {
            log.info("Register " + eventUpgrader + '.');
        }
        eventUpgraderFactories.compute(eventUpgrader.getEventNamedAggregate(), (arg_0, arg_1) -> EventUpgraderFactory.register$lambda$1((Function2)new Function2<EventNamedAggregate, SortedSet<EventUpgrader>, SortedSet<EventUpgrader>>(eventUpgrader){
            final /* synthetic */ EventUpgrader $eventUpgrader;
            {
                this.$eventUpgrader = $eventUpgrader;
                super(2);
            }

            @Nullable
            public final SortedSet<EventUpgrader> invoke(@NotNull EventNamedAggregate eventNamedAggregate, @Nullable SortedSet<EventUpgrader> value) {
                SortedSet sortedSet;
                Intrinsics.checkNotNullParameter((Object)eventNamedAggregate, (String)"<anonymous parameter 0>");
                if (value == null) {
                    Object[] objectArray = new EventUpgrader[]{this.$eventUpgrader};
                    sortedSet = SetsKt.sortedSetOf((Comparator)OrderComparator.INSTANCE, (Object[])objectArray);
                } else {
                    value.add((EventUpgrader)this.$eventUpgrader);
                    sortedSet = value;
                }
                return sortedSet;
            }
        }, arg_0, arg_1));
    }

    @NotNull
    public final Set<EventUpgrader> get(@NotNull EventNamedAggregate eventNamedAggregate) {
        Intrinsics.checkNotNullParameter((Object)eventNamedAggregate, (String)"eventNamedAggregate");
        SortedSet<EventUpgrader> sortedSet = eventUpgraderFactories.get(eventNamedAggregate);
        return sortedSet == null ? SetsKt.emptySet() : (Set)sortedSet;
    }

    @NotNull
    public final DomainEventRecord upgrade(@NotNull DomainEventRecord domainEventRecord) {
        Intrinsics.checkNotNullParameter((Object)domainEventRecord, (String)"domainEventRecord");
        MaterializedNamedAggregate namedAggregate = MaterializedNamedAggregateKt.materialize(domainEventRecord.asAggregateId().getNamedAggregate());
        EventNamedAggregate eventNamedAggregate = EventNamedAggregate.Companion.asEventNamedAggregate(namedAggregate, domainEventRecord.getName());
        Set<EventUpgrader> eventUpgraders = this.get(eventNamedAggregate);
        if (eventUpgraders.isEmpty()) {
            return domainEventRecord;
        }
        MutableDomainEventRecord mutableDomainEventRecord = null;
        mutableDomainEventRecord = MutableDomainEventRecord.Companion.asMutableDomainEventRecord(domainEventRecord);
        Iterable $this$forEach$iv = eventUpgraders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventUpgrader it = (EventUpgrader)element$iv;
            boolean bl = false;
            if (log.isDebugEnabled()) {
                log.debug("Upgrade [" + domainEventRecord.getId() + "]@[" + eventNamedAggregate + "] by " + it + '.');
            }
            mutableDomainEventRecord = MutableDomainEventRecord.Companion.asMutableDomainEventRecord(it.upgrade(mutableDomainEventRecord));
        }
        return domainEventRecord;
    }

    private static final SortedSet register$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SortedSet)$tmp0.invoke(p0, p1);
    }

    static {
        ServiceLoader<EventUpgrader> serviceLoader = ServiceLoader.load(EventUpgrader.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(EventUpgrader::class.java)");
        Iterable $this$forEach$iv = serviceLoader;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventUpgrader it = (EventUpgrader)element$iv;
            boolean bl = false;
            if (log.isInfoEnabled()) {
                log.info("Load " + it + " to register.");
            }
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            INSTANCE.register(it);
        }
    }
}

