/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.messaging.function;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import me.ahoo.wow.api.annotation.OnEvent;
import me.ahoo.wow.api.messaging.Message;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.event.annotation.EventMetadataParserKt;
import me.ahoo.wow.infra.accessor.method.MethodAccessor;
import me.ahoo.wow.infra.reflection.AnnotationScanner;
import me.ahoo.wow.messaging.function.FirstParameterKind;
import me.ahoo.wow.messaging.function.MethodFunctionMetadata;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.modeling.matedata.MetadataNamedAggregateGetter;
import me.ahoo.wow.modeling.matedata.NamedAggregateGetter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001e\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u000b0\nJ\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lme/ahoo/wow/messaging/function/FunctionMetadataParser;", "", "()V", "parse", "Lme/ahoo/wow/messaging/function/MethodFunctionMetadata;", "P", "R", "method", "Ljava/lang/reflect/Method;", "accessorFactory", "Lkotlin/Function1;", "Lme/ahoo/wow/infra/accessor/method/MethodAccessor;", "parseOnEventTopics", "", "bodyType", "Ljava/lang/Class;", "wow-core"})
@SourceDebugExtension(value={"SMAP\nFunctionMetadataParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionMetadataParser.kt\nme/ahoo/wow/messaging/function/FunctionMetadataParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AnnotationScanner.kt\nme/ahoo/wow/infra/reflection/AnnotationScanner\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,99:1\n1#2:100\n73#3,2:101\n11335#4:103\n11670#4,3:104\n*S KotlinDebug\n*F\n+ 1 FunctionMetadataParser.kt\nme/ahoo/wow/messaging/function/FunctionMetadataParser\n*L\n77#1:101,2\n85#1:103\n85#1:104,3\n*E\n"})
public final class FunctionMetadataParser {
    @NotNull
    public static final FunctionMetadataParser INSTANCE = new FunctionMetadataParser();

    private FunctionMetadataParser() {
    }

    @NotNull
    public final <P, R> MethodFunctionMetadata<P, R> parse(@NotNull Method method, @NotNull Function1<? super Method, ? extends MethodAccessor<P, ? extends R>> accessorFactory) {
        Class clazz;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(accessorFactory, (String)"accessorFactory");
        Object[] parameterTypes = method.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(parameterTypes, (String)"parameterTypes");
        if (!(!(parameterTypes.length == 0))) {
            boolean $i$a$-check-FunctionMetadataParser$parse$22 = false;
            String $i$a$-check-FunctionMetadataParser$parse$22 = "The function has at least one parameter.";
            throw new IllegalStateException($i$a$-check-FunctionMetadataParser$parse$22.toString());
        }
        Class firstParameterType = parameterTypes[0];
        FirstParameterKind firstParameterKind = MessageExchange.class.isAssignableFrom(firstParameterType) ? FirstParameterKind.MESSAGE_EXCHANGE : (Message.class.isAssignableFrom(firstParameterType) ? FirstParameterKind.MESSAGE : FirstParameterKind.MESSAGE_BODY);
        switch (WhenMappings.$EnumSwitchMapping$0[firstParameterKind.ordinal()]) {
            case 1: 
            case 2: {
                Type messageWrappedBodyType = method.getGenericParameterTypes()[0];
                Intrinsics.checkNotNull((Object)messageWrappedBodyType, (String)"null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                ParameterizedType parameterizedType = (ParameterizedType)messageWrappedBodyType;
                Type type = parameterizedType.getActualTypeArguments()[0];
                Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                clazz = (Class)type;
                break;
            }
            case 3: {
                clazz = firstParameterType;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Class bodyType = clazz;
        Class[] injectParameterTypes = (Class[])ArraysKt.sliceArray((Object[])parameterTypes, (IntRange)RangesKt.until((int)1, (int)parameterTypes.length));
        Intrinsics.checkNotNullExpressionValue(bodyType, (String)"bodyType");
        Set<Object> topics = this.parseOnEventTopics(method, bodyType);
        return new MethodFunctionMetadata((MethodAccessor)accessorFactory.invoke((Object)method), bodyType, topics, firstParameterKind, injectParameterTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Object> parseOnEventTopics(Method method, Class<?> bodyType) {
        Collection destination$iv$iv;
        void this_$iv;
        AnnotationScanner annotationScanner = AnnotationScanner.INSTANCE;
        AnnotatedElement $this$scan$iv = method;
        boolean $i$f$scan = false;
        String[] targetAnnotationType$iv = OnEvent.class;
        OnEvent onEvent = this_$iv.scan($this$scan$iv, targetAnnotationType$iv);
        if (onEvent == null && !Intrinsics.areEqual((Object)method.getName(), (Object)"onEvent")) {
            return SetsKt.emptySet();
        }
        if (onEvent != null && !(onEvent.value().length == 0)) {
            void $this$mapTo$iv$iv;
            NamedBoundedContext namedBoundedContext = MetadataSearcherKt.asNamedBoundedContext(bodyType);
            if (namedBoundedContext == null) {
                Class<?> clazz = method.getDeclaringClass();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"method.declaringClass");
                namedBoundedContext = MetadataSearcherKt.asNamedBoundedContext(clazz);
            }
            NamedBoundedContext namedBoundedContext2 = namedBoundedContext;
            String[] $this$map$iv = onEvent.value();
            boolean $i$f$map = false;
            targetAnnotationType$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var13_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                NamedBoundedContext namedBoundedContext3 = namedBoundedContext2;
                collection.add(MaterializedNamedAggregateKt.asNamedAggregate((String)it, namedBoundedContext3 != null ? namedBoundedContext3.getContextName() : null));
            }
        } else {
            NamedAggregateGetter<?> namedAggregateGetter = EventMetadataParserKt.asEventMetadata(bodyType).getNamedAggregateGetter();
            if (!(namedAggregateGetter instanceof MetadataNamedAggregateGetter)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return SetsKt.setOf((Object)((MetadataNamedAggregateGetter)namedAggregateGetter).getNamedAggregate());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirstParameterKind.values().length];
            try {
                nArray[FirstParameterKind.MESSAGE_EXCHANGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirstParameterKind.MESSAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirstParameterKind.MESSAGE_BODY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

