/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command.wait;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandId;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.CommandWaitNotifier;
import me.ahoo.wow.command.wait.CommandWaitNotifierKt;
import me.ahoo.wow.command.wait.CommandWaitNotifierSubscriber;
import me.ahoo.wow.command.wait.WaitStrategyInfo;
import me.ahoo.wow.messaging.handler.MessageExchange;
import org.jetbrains.annotations.NotNull;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0010\b\u0000\u0010\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/ahoo/wow/command/wait/MonoCommandWaitNotifier;", "M", "Lme/ahoo/wow/messaging/handler/MessageExchange;", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "commandWaitNotifier", "Lme/ahoo/wow/command/wait/CommandWaitNotifier;", "processingStage", "Lme/ahoo/wow/command/wait/CommandStage;", "messageExchange", "source", "(Lme/ahoo/wow/command/wait/CommandWaitNotifier;Lme/ahoo/wow/command/wait/CommandStage;Lme/ahoo/wow/messaging/handler/MessageExchange;Lreactor/core/publisher/Mono;)V", "Lme/ahoo/wow/messaging/handler/MessageExchange;", "subscribe", "", "actual", "Lreactor/core/CoreSubscriber;", "wow-core"})
public final class MonoCommandWaitNotifier<M extends MessageExchange<?, ?>>
extends Mono<Void> {
    @NotNull
    private final CommandWaitNotifier commandWaitNotifier;
    @NotNull
    private final CommandStage processingStage;
    @NotNull
    private final M messageExchange;
    @NotNull
    private final Mono<Void> source;

    public MonoCommandWaitNotifier(@NotNull CommandWaitNotifier commandWaitNotifier, @NotNull CommandStage processingStage, @NotNull M messageExchange, @NotNull Mono<Void> source) {
        Intrinsics.checkNotNullParameter((Object)commandWaitNotifier, (String)"commandWaitNotifier");
        Intrinsics.checkNotNullParameter((Object)((Object)processingStage), (String)"processingStage");
        Intrinsics.checkNotNullParameter(messageExchange, (String)"messageExchange");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.commandWaitNotifier = commandWaitNotifier;
        this.processingStage = processingStage;
        this.messageExchange = messageExchange;
        this.source = source;
    }

    public void subscribe(@NotNull CoreSubscriber<? super Void> actual) {
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        Object message = this.messageExchange.getMessage();
        if (!(message instanceof CommandId)) {
            this.source.subscribe(actual);
            return;
        }
        WaitStrategyInfo waitStrategyInfo = CommandWaitNotifierKt.extractWaitStrategy(message.getHeader());
        if (waitStrategyInfo == null) {
            this.source.subscribe(actual);
            return;
        }
        WaitStrategyInfo waitStrategy = waitStrategyInfo;
        if (!waitStrategy.getStage().shouldNotify(this.processingStage)) {
            this.source.subscribe(actual);
            return;
        }
        this.source.subscribe((CoreSubscriber)new CommandWaitNotifierSubscriber<M>(this.commandWaitNotifier, this.processingStage, waitStrategy, ((CommandId)message).getCommandId(), this.messageExchange, actual));
    }
}

