/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.modeling.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.annotation.AggregateAnnotationParser;
import me.ahoo.wow.api.annotation.OnSourcing;
import me.ahoo.wow.infra.accessor.constructor.ConstructorAccessor;
import me.ahoo.wow.infra.accessor.constructor.DefaultConstructorAccessor;
import me.ahoo.wow.infra.accessor.property.PropertyGetter;
import me.ahoo.wow.infra.reflection.ClassVisitor;
import me.ahoo.wow.messaging.function.FunctionMetadataParser;
import me.ahoo.wow.messaging.function.MethodFunctionMetadata;
import me.ahoo.wow.modeling.annotation.StateAggregateMetadataParserKt;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/ahoo/wow/modeling/annotation/StateAggregateMetadataVisitor;", "S", "", "Lme/ahoo/wow/infra/reflection/ClassVisitor;", "stateAggregateType", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "aggregateIdGetter", "Lme/ahoo/wow/infra/accessor/property/PropertyGetter;", "", "constructor", "Ljava/lang/reflect/Constructor;", "namedIdField", "Ljava/lang/reflect/Field;", "sourcingFunctionRegistry", "", "Lme/ahoo/wow/messaging/function/MethodFunctionMetadata;", "Ljava/lang/Void;", "asMetadata", "Lme/ahoo/wow/modeling/matedata/StateAggregateMetadata;", "end", "", "visitField", "field", "visitMethod", "method", "Ljava/lang/reflect/Method;", "wow-core"})
public final class StateAggregateMetadataVisitor<S>
implements ClassVisitor {
    @NotNull
    private final Class<S> stateAggregateType;
    @NotNull
    private final Constructor<S> constructor;
    @Nullable
    private PropertyGetter<? super S, String> aggregateIdGetter;
    @NotNull
    private final Map<Class<?>, MethodFunctionMetadata<S, Void>> sourcingFunctionRegistry;
    @Nullable
    private Field namedIdField;

    public StateAggregateMetadataVisitor(@NotNull Class<S> stateAggregateType) {
        Intrinsics.checkNotNullParameter(stateAggregateType, (String)"stateAggregateType");
        this.stateAggregateType = stateAggregateType;
        this.sourcingFunctionRegistry = new HashMap();
        try {
            Class[] classArray = new Class[]{String.class};
            Constructor<S> constructor = this.stateAggregateType.getDeclaredConstructor(classArray);
            Intrinsics.checkNotNullExpressionValue(constructor, (String)"stateAggregateType.getDe\u2026uctor(String::class.java)");
            this.constructor = constructor;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to parse StateAggregate[" + this.stateAggregateType + "] metadata: Not defined Constructor[ctor(aggregateId)].");
        }
    }

    @Override
    public void visitField(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (this.aggregateIdGetter == null) {
            this.aggregateIdGetter = AggregateAnnotationParser.INSTANCE.asAggregateIdGetterIfAnnotated(field);
        }
        if (this.namedIdField == null && Intrinsics.areEqual((Object)"id", (Object)field.getName())) {
            this.namedIdField = field;
        }
    }

    @Override
    public void visitMethod(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (this.aggregateIdGetter == null) {
            this.aggregateIdGetter = AggregateAnnotationParser.INSTANCE.asAggregateIdGetterIfAnnotated(method);
        }
        if (method.isAnnotationPresent(OnSourcing.class) || Intrinsics.areEqual((Object)"onSourcing", (Object)method.getName()) && method.getParameterCount() == 1) {
            MethodFunctionMetadata functionMetadata = FunctionMetadataParser.INSTANCE.asFunctionMetadata(method);
            this.sourcingFunctionRegistry.putIfAbsent(functionMetadata.getSupportedType(), functionMetadata);
        }
    }

    @Override
    public void end() {
        if (this.aggregateIdGetter != null || this.namedIdField == null) {
            return;
        }
        Field field = this.namedIdField;
        Intrinsics.checkNotNull((Object)field);
        this.aggregateIdGetter = AggregateAnnotationParser.INSTANCE.asStringGetter(field);
    }

    @NotNull
    public final StateAggregateMetadata<S> asMetadata() {
        if (this.sourcingFunctionRegistry.isEmpty() && StateAggregateMetadataParserKt.access$getLog$p().isWarnEnabled()) {
            StateAggregateMetadataParserKt.access$getLog$p().warn("StateAggregate[" + this.stateAggregateType + "] requires at least one OnSourcing function!");
        }
        PropertyGetter<? super S, String> propertyGetter = this.aggregateIdGetter;
        if (propertyGetter == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return new StateAggregateMetadata<S>(this.stateAggregateType, (ConstructorAccessor)new DefaultConstructorAccessor<S>(this.constructor), propertyGetter, this.sourcingFunctionRegistry);
    }
}

