/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command.wait;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.WaitSignal;
import me.ahoo.wow.command.wait.WaitStrategy;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lme/ahoo/wow/command/wait/WaitingFor;", "Lme/ahoo/wow/command/wait/WaitStrategy;", "stage", "Lme/ahoo/wow/command/wait/CommandStage;", "(Lme/ahoo/wow/command/wait/CommandStage;)V", "sink", "Lreactor/core/publisher/Sinks$One;", "Lme/ahoo/wow/command/wait/WaitSignal;", "getStage", "()Lme/ahoo/wow/command/wait/CommandStage;", "error", "", "throwable", "", "next", "signal", "toString", "", "waiting", "Lreactor/core/publisher/Mono;", "Companion", "wow-core"})
public final class WaitingFor
implements WaitStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommandStage stage;
    @NotNull
    private final Sinks.One<WaitSignal> sink;
    private static final Logger log = LoggerFactory.getLogger(WaitingFor.class);

    public WaitingFor(@NotNull CommandStage stage) {
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        this.stage = stage;
        Sinks.One one = Sinks.one();
        Intrinsics.checkNotNullExpressionValue((Object)one, (String)"one()");
        this.sink = one;
    }

    @NotNull
    public final CommandStage getStage() {
        return this.stage;
    }

    @Override
    @NotNull
    public Mono<WaitSignal> waiting() {
        Mono mono = this.sink.asMono();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"sink.asMono()");
        return mono;
    }

    @Override
    public void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.sink.tryEmitError(throwable);
    }

    @Override
    public void next(@NotNull WaitSignal signal) {
        Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
        if (log.isDebugEnabled()) {
            log.debug("Next " + signal + '.');
        }
        if (!signal.getSucceeded()) {
            this.sink.tryEmitValue((Object)signal);
            return;
        }
        if (this.stage == CommandStage.PROJECTED && !signal.isLastProjection()) {
            return;
        }
        if (this.stage == signal.getStage()) {
            this.sink.tryEmitValue((Object)signal);
            return;
        }
    }

    @NotNull
    public String toString() {
        return "WaitingFor(stage='" + (Object)((Object)this.stage) + "')";
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/ahoo/wow/command/wait/WaitingFor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "processed", "Lme/ahoo/wow/command/wait/WaitingFor;", "projected", "snapshot", "stage", "", "Lme/ahoo/wow/command/wait/CommandStage;", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WaitingFor processed() {
            return this.stage(CommandStage.PROCESSED);
        }

        @NotNull
        public final WaitingFor snapshot() {
            return this.stage(CommandStage.SNAPSHOT);
        }

        @NotNull
        public final WaitingFor projected() {
            return this.stage(CommandStage.PROJECTED);
        }

        @NotNull
        public final WaitingFor stage(@NotNull CommandStage stage) {
            Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
            return new WaitingFor(stage);
        }

        @NotNull
        public final WaitingFor stage(@NotNull String stage) {
            Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
            String string = stage;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
            return new WaitingFor(CommandStage.valueOf(string2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

