/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.eventsourcing;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.eventsourcing.AbstractEventStore;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.EventVersionConflictException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H$J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH$\u00a8\u0006\u0012"}, d2={"Lme/ahoo/wow/eventsourcing/AbstractEventStore;", "Lme/ahoo/wow/eventsourcing/EventStore;", "()V", "append", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "eventStream", "Lme/ahoo/wow/event/DomainEventStream;", "appendStream", "load", "Lreactor/core/publisher/Flux;", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "headVersion", "", "tailVersion", "loadStream", "Companion", "wow-core"})
public abstract class AbstractEventStore
implements EventStore {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;

    @Override
    @NotNull
    public Mono<Void> append(@NotNull DomainEventStream eventStream) {
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        if (log.isDebugEnabled()) {
            log.debug("Append {} - version[{}]", (Object)eventStream.getAggregateId(), (Object)eventStream.getVersion());
        }
        Mono mono = this.appendStream(eventStream).onErrorMap(EventVersionConflictException.class, arg_0 -> AbstractEventStore.append$lambda$0(append.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"appendStream(eventStream\u2026          }\n            }");
        return mono;
    }

    @NotNull
    protected abstract Mono<Void> appendStream(@NotNull DomainEventStream var1);

    @Override
    @NotNull
    public Flux<DomainEventStream> load(@NotNull AggregateId aggregateId, int headVersion, int tailVersion) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        if (log.isDebugEnabled()) {
            Object[] objectArray = new Object[]{aggregateId, headVersion, tailVersion};
            log.debug("Load {} - headVersion[{}] - tailVersion[{}].", objectArray);
        }
        if (!(headVersion > -1)) {
            boolean $i$a$-require-AbstractEventStore$load$32 = false;
            String $i$a$-require-AbstractEventStore$load$32 = aggregateId + " headVersion[" + headVersion + "] must be greater than -1!";
            throw new IllegalArgumentException($i$a$-require-AbstractEventStore$load$32.toString());
        }
        if (!(tailVersion >= headVersion)) {
            boolean bl = false;
            String string = aggregateId + " headVersion[" + headVersion + "] must be greater than or equal to 0!";
            throw new IllegalArgumentException(string.toString());
        }
        return this.loadStream(aggregateId, headVersion, tailVersion);
    }

    @NotNull
    protected abstract Flux<DomainEventStream> loadStream(@NotNull AggregateId var1, int var2, int var3);

    private static final Throwable append$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Throwable)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger(AbstractEventStore.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(AbstractEventStore::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/wow/eventsourcing/AbstractEventStore$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "wow-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

