/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.modeling.command;

import java.time.Duration;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.configuration.MetadataSearcher;
import me.ahoo.wow.ioc.ServiceProvider;
import me.ahoo.wow.messaging.MessageBusKt;
import me.ahoo.wow.messaging.dispatcher.AbstractMessageDispatcher;
import me.ahoo.wow.messaging.dispatcher.HandledSignal;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.modeling.command.AggregateDispatcher;
import me.ahoo.wow.modeling.command.AggregateProcessor;
import me.ahoo.wow.modeling.command.AggregateProcessorFactory;
import me.ahoo.wow.modeling.command.CommandHandler;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"BG\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001cH\u0002J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lme/ahoo/wow/modeling/command/AggregateDispatcher;", "Lme/ahoo/wow/messaging/dispatcher/AbstractMessageDispatcher;", "Lme/ahoo/wow/messaging/dispatcher/HandledSignal;", "name", "", "topics", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "aggregateTtl", "Ljava/time/Duration;", "commandBus", "Lme/ahoo/wow/command/CommandBus;", "aggregateProcessorFactory", "Lme/ahoo/wow/modeling/command/AggregateProcessorFactory;", "commandHandler", "Lme/ahoo/wow/modeling/command/CommandHandler;", "serviceProvider", "Lme/ahoo/wow/ioc/ServiceProvider;", "(Ljava/lang/String;Ljava/util/Set;Ljava/time/Duration;Lme/ahoo/wow/command/CommandBus;Lme/ahoo/wow/modeling/command/AggregateProcessorFactory;Lme/ahoo/wow/modeling/command/CommandHandler;Lme/ahoo/wow/ioc/ServiceProvider;)V", "getName", "()Ljava/lang/String;", "scheduler", "Lreactor/core/scheduler/Scheduler;", "getTopics", "()Ljava/util/Set;", "handleGroupedCommand", "Lreactor/core/publisher/Mono;", "grouped", "Lreactor/core/publisher/GroupedFlux;", "Lme/ahoo/wow/api/modeling/AggregateId;", "Lme/ahoo/wow/command/ServerCommandExchange;", "", "start", "", "Companion", "wow-core"})
public final class AggregateDispatcher
extends AbstractMessageDispatcher<HandledSignal> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Set<NamedAggregate> topics;
    @NotNull
    private final Duration aggregateTtl;
    @NotNull
    private final CommandBus commandBus;
    @NotNull
    private final AggregateProcessorFactory aggregateProcessorFactory;
    @NotNull
    private final CommandHandler commandHandler;
    @NotNull
    private final ServiceProvider serviceProvider;
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private static final Logger log;

    public AggregateDispatcher(@NotNull String name, @NotNull Set<? extends NamedAggregate> topics, @NotNull Duration aggregateTtl, @NotNull CommandBus commandBus, @NotNull AggregateProcessorFactory aggregateProcessorFactory, @NotNull CommandHandler commandHandler, @NotNull ServiceProvider serviceProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        Intrinsics.checkNotNullParameter((Object)aggregateTtl, (String)"aggregateTtl");
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"commandBus");
        Intrinsics.checkNotNullParameter((Object)aggregateProcessorFactory, (String)"aggregateProcessorFactory");
        Intrinsics.checkNotNullParameter((Object)commandHandler, (String)"commandHandler");
        Intrinsics.checkNotNullParameter((Object)serviceProvider, (String)"serviceProvider");
        this.name = name;
        this.topics = topics;
        this.aggregateTtl = aggregateTtl;
        this.commandBus = commandBus;
        this.aggregateProcessorFactory = aggregateProcessorFactory;
        this.commandHandler = commandHandler;
        this.serviceProvider = serviceProvider;
        Scheduler scheduler = Schedulers.newParallel((String)AggregateDispatcher.class.getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"newParallel(AggregateDis\u2026r::class.java.simpleName)");
        this.scheduler = scheduler;
    }

    public /* synthetic */ AggregateDispatcher(String string, Set set, Duration duration, CommandBus commandBus, AggregateProcessorFactory aggregateProcessorFactory, CommandHandler commandHandler, ServiceProvider serviceProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "AggregateDispatcher";
        }
        if ((n & 2) != 0) {
            set = CollectionsKt.toSet((Iterable)MetadataSearcher.INSTANCE.getNamedAggregateType().keySet());
        }
        this(string, set, duration, commandBus, aggregateProcessorFactory, commandHandler, serviceProvider);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Set<NamedAggregate> getTopics() {
        return this.topics;
    }

    @Override
    public void start() {
        MessageBusKt.writeReceiverGroup(this.commandBus.receive(this.getTopics()), this.getName()).groupBy(arg_0 -> AggregateDispatcher.start$lambda$0(start.1.INSTANCE, arg_0)).flatMap(arg_0 -> AggregateDispatcher.start$lambda$1((Function1)new Function1<GroupedFlux<AggregateId, ServerCommandExchange<Object>>, Publisher<? extends HandledSignal>>(this){
            final /* synthetic */ AggregateDispatcher this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Publisher<? extends HandledSignal> invoke(GroupedFlux<AggregateId, ServerCommandExchange<Object>> it) {
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                return (Publisher)AggregateDispatcher.access$handleGroupedCommand(this.this$0, it);
            }
        }, arg_0)).subscribe((CoreSubscriber)this);
    }

    private final Mono<HandledSignal> handleGroupedCommand(GroupedFlux<AggregateId, ServerCommandExchange<Object>> grouped) {
        if (log.isDebugEnabled()) {
            log.debug('[' + this.getName() + "] Create {} GroupedFlux - Timeout {}.", grouped.key(), (Object)this.aggregateTtl);
        }
        Object object = grouped.key();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"grouped.key()");
        AggregateId aggregateId = (AggregateId)object;
        Object object2 = MetadataSearcher.INSTANCE.getNamedAggregateType().get((Object)aggregateId.getNamedAggregate());
        Intrinsics.checkNotNull((Object)object2);
        Class aggregateType = (Class)object2;
        AggregateMetadata aggregateMetadata = AggregateMetadataParserKt.asAggregateMetadata(aggregateType);
        AggregateProcessor<Object> aggregateProcessor = this.aggregateProcessorFactory.create(aggregateId, aggregateMetadata);
        Mono mono = grouped.publishOn(this.scheduler).timeout(this.aggregateTtl, (Publisher)Mono.defer(() -> AggregateDispatcher.handleGroupedCommand$lambda$2(this, aggregateId))).concatMap(arg_0 -> AggregateDispatcher.handleGroupedCommand$lambda$3((Function1)new Function1<ServerCommandExchange<Object>, Publisher<? extends Void>>(this, aggregateProcessor){
            final /* synthetic */ AggregateDispatcher this$0;
            final /* synthetic */ AggregateProcessor<Object> $aggregateProcessor;
            {
                this.this$0 = $receiver;
                this.$aggregateProcessor = $aggregateProcessor;
                super(1);
            }

            public final Publisher<? extends Void> invoke(ServerCommandExchange<Object> it) {
                it.setServiceProvider(AggregateDispatcher.access$getServiceProvider$p(this.this$0));
                it.setAggregateProcessor(this.$aggregateProcessor);
                CommandHandler commandHandler = AggregateDispatcher.access$getCommandHandler$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                return (Publisher)commandHandler.handle((MessageExchange)it);
            }
        }, arg_0)).then(Mono.just((Object)HandledSignal.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"private fun handleGroupe\u2026ust(HandledSignal))\n    }");
        return mono;
    }

    private static final AggregateId start$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AggregateId)$tmp0.invoke(p0);
    }

    private static final Publisher start$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Mono handleGroupedCommand$lambda$2(AggregateDispatcher this$0, AggregateId $aggregateId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateId, (String)"$aggregateId");
        if (log.isDebugEnabled()) {
            log.debug('[' + this$0.getName() + "] Clear {} group: has not received commands for {}.", (Object)$aggregateId, (Object)this$0.aggregateTtl);
        }
        return Mono.empty();
    }

    private static final Publisher handleGroupedCommand$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Mono access$handleGroupedCommand(AggregateDispatcher $this, GroupedFlux grouped) {
        return $this.handleGroupedCommand((GroupedFlux<AggregateId, ServerCommandExchange<Object>>)grouped);
    }

    public static final /* synthetic */ ServiceProvider access$getServiceProvider$p(AggregateDispatcher $this) {
        return $this.serviceProvider;
    }

    public static final /* synthetic */ CommandHandler access$getCommandHandler$p(AggregateDispatcher $this) {
        return $this.commandHandler;
    }

    static {
        Logger logger = LoggerFactory.getLogger(AggregateDispatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(AggregateDispatcher::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/wow/modeling/command/AggregateDispatcher$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "wow-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

