/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.infra.idempotency;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import me.ahoo.wow.infra.idempotency.IdempotencyChecker;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0013\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/ahoo/wow/infra/idempotency/BloomFilterIdempotencyChecker;", "Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "expectedInsertions", "", "fpp", "", "(JD)V", "bloomFilter", "Lcom/google/common/hash/BloomFilter;", "", "(Lcom/google/common/hash/BloomFilter;)V", "check", "Lreactor/core/publisher/Mono;", "", "element", "Companion", "wow-core"})
public final class BloomFilterIdempotencyChecker
implements IdempotencyChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BloomFilter<String> bloomFilter;
    @NotNull
    private static final Funnel<String> STRING_FUNNEL = BloomFilterIdempotencyChecker::STRING_FUNNEL$lambda$1;

    public BloomFilterIdempotencyChecker(@NotNull BloomFilter<String> bloomFilter) {
        Intrinsics.checkNotNullParameter(bloomFilter, (String)"bloomFilter");
        this.bloomFilter = bloomFilter;
    }

    public BloomFilterIdempotencyChecker(long expectedInsertions, double fpp) {
        BloomFilter bloomFilter = BloomFilter.create(STRING_FUNNEL, (long)expectedInsertions, (double)fpp);
        Intrinsics.checkNotNullExpressionValue((Object)bloomFilter, (String)"create<String>(\n        \u2026           fpp,\n        )");
        this((BloomFilter<String>)bloomFilter);
    }

    @Override
    @NotNull
    public Mono<Boolean> check(@NotNull String element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Mono mono = Mono.fromCallable(() -> BloomFilterIdempotencyChecker.check$lambda$0(this, element));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fromCallable {\n         \u2026          false\n        }");
        return mono;
    }

    private static final Boolean check$lambda$0(BloomFilterIdempotencyChecker this$0, String $element) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        boolean contain = this$0.bloomFilter.mightContain((Object)$element);
        if (!contain) {
            this$0.bloomFilter.put((Object)$element);
            return true;
        }
        return false;
    }

    private static final void STRING_FUNNEL$lambda$1(String from, PrimitiveSink into) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        into.putString((CharSequence)from, Charsets.UTF_8);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lme/ahoo/wow/infra/idempotency/BloomFilterIdempotencyChecker$Companion;", "", "()V", "STRING_FUNNEL", "Lcom/google/common/hash/Funnel;", "", "kotlin.jvm.PlatformType", "getSTRING_FUNNEL", "()Lcom/google/common/hash/Funnel;", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Funnel<String> getSTRING_FUNNEL() {
            return STRING_FUNNEL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

