/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.messaging.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.annotation.OnMessage;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.infra.reflection.AnnotationScanner;
import me.ahoo.wow.infra.reflection.ClassVisitor;
import me.ahoo.wow.messaging.function.MethodFunctionMetadata;
import me.ahoo.wow.messaging.function.MethodFunctionMetadataKt;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.messaging.processor.ProcessorMetadata;
import me.ahoo.wow.naming.annotation.PascalToSnakeConverterKt;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\f\b\u0002\u0010\u0005*\u0006\u0012\u0002\b\u00030\u00062\u00020\u0007B5\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/ahoo/wow/messaging/processor/ProcessorMetadataVisitor;", "P", "", "OM", "", "M", "Lme/ahoo/wow/messaging/handler/MessageExchange;", "Lme/ahoo/wow/infra/reflection/ClassVisitor;", "processorType", "Ljava/lang/Class;", "onMessageType", "functionCondition", "Lkotlin/Function1;", "Ljava/lang/reflect/Method;", "", "(Ljava/lang/Class;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)V", "functionRegistry", "", "Lme/ahoo/wow/messaging/function/MethodFunctionMetadata;", "Lreactor/core/publisher/Mono;", "onMessage", "Lme/ahoo/wow/api/annotation/OnMessage;", "asMetadata", "Lme/ahoo/wow/messaging/processor/ProcessorMetadata;", "visitMethod", "", "method", "wow-core"})
@SourceDebugExtension(value={"SMAP\nProcessorMetadataParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessorMetadataParser.kt\nme/ahoo/wow/messaging/processor/ProcessorMetadataVisitor\n+ 2 AnnotationScanner.kt\nme/ahoo/wow/infra/reflection/AnnotationScanner\n*L\n1#1,80:1\n73#2,2:81\n*S KotlinDebug\n*F\n+ 1 ProcessorMetadataParser.kt\nme/ahoo/wow/messaging/processor/ProcessorMetadataVisitor\n*L\n50#1:81,2\n*E\n"})
public final class ProcessorMetadataVisitor<P, OM extends Annotation, M extends MessageExchange<?>>
implements ClassVisitor {
    @NotNull
    private final Class<P> processorType;
    @NotNull
    private final Class<OM> onMessageType;
    @NotNull
    private final Function1<Method, Boolean> functionCondition;
    @NotNull
    private final OnMessage onMessage;
    @NotNull
    private final Set<MethodFunctionMetadata<P, Mono<?>>> functionRegistry;

    /*
     * WARNING - void declaration
     */
    public ProcessorMetadataVisitor(@NotNull Class<P> processorType, @NotNull Class<OM> onMessageType, @NotNull Function1<? super Method, Boolean> functionCondition) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(processorType, (String)"processorType");
        Intrinsics.checkNotNullParameter(onMessageType, (String)"onMessageType");
        Intrinsics.checkNotNullParameter(functionCondition, (String)"functionCondition");
        this.processorType = processorType;
        this.onMessageType = onMessageType;
        this.functionCondition = functionCondition;
        AnnotationScanner annotationScanner = AnnotationScanner.INSTANCE;
        AnnotatedElement $this$scan$iv = this.onMessageType;
        boolean $i$f$scan = false;
        Class<OnMessage> targetAnnotationType$iv = OnMessage.class;
        OnMessage onMessage = this_$iv.scan($this$scan$iv, targetAnnotationType$iv);
        Intrinsics.checkNotNull((Object)onMessage);
        this.onMessage = onMessage;
        this.functionRegistry = new LinkedHashSet();
    }

    @Override
    public void visitMethod(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (method.getParameterCount() == 0) {
            return;
        }
        if (!method.isAnnotationPresent(this.onMessageType) && !Intrinsics.areEqual((Object)this.onMessage.defaultHandlerName(), (Object)method.getName())) {
            return;
        }
        if (!((Boolean)this.functionCondition.invoke((Object)method)).booleanValue()) {
            return;
        }
        MethodFunctionMetadata handler = MethodFunctionMetadataKt.asMonoFunctionMetadata(method);
        this.functionRegistry.add(handler);
    }

    @NotNull
    public final ProcessorMetadata<P, M> asMetadata() {
        return new ProcessorMetadata(MetadataSearcherKt.asRequiredNamedBoundedContext(this.processorType), PascalToSnakeConverterKt.asName(this.processorType), this.processorType, this.functionRegistry);
    }
}

