/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.modeling.command;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.exception.WowExceptionsKt;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.modeling.NamedTypedAggregate;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.modeling.command.AggregateProcessor;
import me.ahoo.wow.modeling.command.CommandAggregate;
import me.ahoo.wow.modeling.command.CommandAggregateFactory;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.matedata.CommandAggregateMetadata;
import me.ahoo.wow.modeling.state.StateAggregate;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 **\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005:\u0001*B9\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0096\u0001J\u0011\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020$H\u0096\u0001J\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u0014X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00020\u0014X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lme/ahoo/wow/modeling/command/RetryableAggregateProcessor;", "C", "", "S", "Lme/ahoo/wow/modeling/command/AggregateProcessor;", "Lme/ahoo/wow/api/modeling/NamedTypedAggregate;", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "aggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "stateAggregateRepository", "Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "commandAggregateFactory", "Lme/ahoo/wow/modeling/command/CommandAggregateFactory;", "(Lme/ahoo/wow/api/modeling/AggregateId;Lme/ahoo/wow/modeling/matedata/AggregateMetadata;Lme/ahoo/wow/modeling/state/StateAggregateFactory;Lme/ahoo/wow/modeling/state/StateAggregateRepository;Lme/ahoo/wow/modeling/command/CommandAggregateFactory;)V", "getAggregateId", "()Lme/ahoo/wow/api/modeling/AggregateId;", "aggregateName", "", "getAggregateName", "()Ljava/lang/String;", "aggregateType", "Ljava/lang/Class;", "getAggregateType", "()Ljava/lang/Class;", "contextName", "getContextName", "retryStrategy", "Lreactor/util/retry/Retry;", "isSameAggregateName", "", "other", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "isSameBoundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "process", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/event/DomainEventStream;", "exchange", "Lme/ahoo/wow/command/ServerCommandExchange;", "Companion", "wow-core"})
public final class RetryableAggregateProcessor<C, S>
implements AggregateProcessor<C>,
NamedTypedAggregate<C> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final AggregateId aggregateId;
    @NotNull
    private final AggregateMetadata<C, S> aggregateMetadata;
    @NotNull
    private final StateAggregateFactory aggregateFactory;
    @NotNull
    private final StateAggregateRepository stateAggregateRepository;
    @NotNull
    private final CommandAggregateFactory commandAggregateFactory;
    private final /* synthetic */ CommandAggregateMetadata<C> $$delegate_0;
    @NotNull
    private final Retry retryStrategy;
    private static final Logger log = LoggerFactory.getLogger(RetryableAggregateProcessor.class);
    private static final long MAX_RETRIES = 3L;
    private static final Duration MIN_BACKOFF = Duration.ofSeconds(2L);

    public RetryableAggregateProcessor(@NotNull AggregateId aggregateId, @NotNull AggregateMetadata<C, S> aggregateMetadata, @NotNull StateAggregateFactory aggregateFactory, @NotNull StateAggregateRepository stateAggregateRepository, @NotNull CommandAggregateFactory commandAggregateFactory) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Intrinsics.checkNotNullParameter(aggregateMetadata, (String)"aggregateMetadata");
        Intrinsics.checkNotNullParameter((Object)aggregateFactory, (String)"aggregateFactory");
        Intrinsics.checkNotNullParameter((Object)stateAggregateRepository, (String)"stateAggregateRepository");
        Intrinsics.checkNotNullParameter((Object)commandAggregateFactory, (String)"commandAggregateFactory");
        this.aggregateId = aggregateId;
        this.aggregateMetadata = aggregateMetadata;
        this.aggregateFactory = aggregateFactory;
        this.stateAggregateRepository = stateAggregateRepository;
        this.commandAggregateFactory = commandAggregateFactory;
        this.$$delegate_0 = aggregateMetadata.getCommand();
        RetryBackoffSpec retryBackoffSpec = Retry.backoff((long)3L, (Duration)MIN_BACKOFF).filter(arg_0 -> RetryableAggregateProcessor.retryStrategy$lambda$0((Function1)new Function1<Throwable, Boolean>(this){
            final /* synthetic */ RetryableAggregateProcessor<C, S> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Throwable it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                boolean retryable = WowExceptionsKt.getRetryable((Throwable)it);
                if (retryable && RetryableAggregateProcessor.access$getLog$cp().isWarnEnabled()) {
                    RetryableAggregateProcessor.access$getLog$cp().warn("Retry {}.", (Object)this.this$0.getAggregateId(), (Object)it);
                }
                return retryable;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)retryBackoffSpec, (String)"backoff(MAX_RETRIES, MIN\u2026      retryable\n        }");
        this.retryStrategy = (Retry)retryBackoffSpec;
    }

    @Override
    @NotNull
    public AggregateId getAggregateId() {
        return this.aggregateId;
    }

    @NotNull
    public String getAggregateName() {
        return this.$$delegate_0.getAggregateName();
    }

    @NotNull
    public Class<C> getAggregateType() {
        return this.$$delegate_0.getAggregateType();
    }

    @NotNull
    public String getContextName() {
        return this.$$delegate_0.getContextName();
    }

    public boolean isSameAggregateName(@NotNull NamedAggregate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.$$delegate_0.isSameAggregateName(other);
    }

    public boolean isSameBoundedContext(@NotNull NamedBoundedContext other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.$$delegate_0.isSameBoundedContext(other);
    }

    @Override
    @NotNull
    public Mono<DomainEventStream> process(@NotNull ServerCommandExchange<?> exchange) {
        Intrinsics.checkNotNullParameter(exchange, (String)"exchange");
        Mono<StateAggregate<S>> stateAggregateMono = ((CommandMessage)exchange.getMessage()).isCreate() ? this.aggregateFactory.create(this.aggregateMetadata.getState(), ((CommandMessage)exchange.getMessage()).getAggregateId()) : this.stateAggregateRepository.load(this.aggregateMetadata.getState(), this.getAggregateId());
        Mono mono = stateAggregateMono.map(arg_0 -> RetryableAggregateProcessor.process$lambda$1((Function1)new Function1<StateAggregate<S>, CommandAggregate<C, S>>(this){
            final /* synthetic */ RetryableAggregateProcessor<C, S> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final CommandAggregate<C, S> invoke(StateAggregate<S> it) {
                CommandAggregateFactory commandAggregateFactory = RetryableAggregateProcessor.access$getCommandAggregateFactory$p(this.this$0);
                AggregateMetadata aggregateMetadata = RetryableAggregateProcessor.access$getAggregateMetadata$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                return commandAggregateFactory.create(aggregateMetadata, it);
            }
        }, arg_0)).flatMap(arg_0 -> RetryableAggregateProcessor.process$lambda$2((Function1)new Function1<CommandAggregate<C, S>, Mono<? extends DomainEventStream>>(exchange){
            final /* synthetic */ ServerCommandExchange<?> $exchange;
            {
                this.$exchange = $exchange;
                super(1);
            }

            public final Mono<? extends DomainEventStream> invoke(CommandAggregate<C, S> it) {
                return it.process(this.$exchange);
            }
        }, arg_0)).retryWhen(this.retryStrategy);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"override fun process(exc\u2026When(retryStrategy)\n    }");
        return mono;
    }

    private static final boolean retryStrategy$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CommandAggregate process$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CommandAggregate)$tmp0.invoke(p0);
    }

    private static final Mono process$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ CommandAggregateFactory access$getCommandAggregateFactory$p(RetryableAggregateProcessor $this) {
        return $this.commandAggregateFactory;
    }

    public static final /* synthetic */ AggregateMetadata access$getAggregateMetadata$p(RetryableAggregateProcessor $this) {
        return $this.aggregateMetadata;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/ahoo/wow/modeling/command/RetryableAggregateProcessor$Companion;", "", "()V", "MAX_RETRIES", "", "MIN_BACKOFF", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "wow-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

