/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.modeling.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.annotation.OnCommand;
import me.ahoo.wow.api.annotation.OnError;
import me.ahoo.wow.api.annotation.StaticTenantId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.configuration.MetadataSearcher;
import me.ahoo.wow.infra.accessor.constructor.ConstructorAccessor;
import me.ahoo.wow.infra.accessor.constructor.DefaultConstructorAccessor;
import me.ahoo.wow.infra.reflection.AnnotationScanner;
import me.ahoo.wow.infra.reflection.ClassMetadata;
import me.ahoo.wow.infra.reflection.ClassVisitor;
import me.ahoo.wow.messaging.function.MethodFunctionMetadata;
import me.ahoo.wow.messaging.function.MethodFunctionMetadataKt;
import me.ahoo.wow.metadata.CacheableMetadataParser;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.modeling.annotation.StateAggregateMetadataParserKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.matedata.CommandAggregateMetadata;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00030\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\b"}, d2={"Lme/ahoo/wow/modeling/annotation/AggregateMetadataParser;", "Lme/ahoo/wow/metadata/CacheableMetadataParser;", "Ljava/lang/Class;", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "()V", "parseAsMetadata", "type", "AggregateMetadataVisitor", "wow-core"})
public final class AggregateMetadataParser
extends CacheableMetadataParser<Class<?>, AggregateMetadata<?, ?>> {
    @NotNull
    public static final AggregateMetadataParser INSTANCE = new AggregateMetadataParser();

    private AggregateMetadataParser() {
    }

    @Override
    @NotNull
    public AggregateMetadata<?, ?> parseAsMetadata(@NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        AggregateMetadataVisitor visitor = new AggregateMetadataVisitor(type);
        ClassMetadata.visit(type, visitor);
        return visitor.asMetadata();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\b\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/ahoo/wow/modeling/annotation/AggregateMetadataParser$AggregateMetadataVisitor;", "C", "", "S", "Lme/ahoo/wow/infra/reflection/ClassVisitor;", "commandAggregateType", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "commandFunctionRegistry", "", "Lme/ahoo/wow/messaging/function/MethodFunctionMetadata;", "Lreactor/core/publisher/Mono;", "constructor", "Ljava/lang/reflect/Constructor;", "errorFunctionRegistry", "stateAggregateMetadata", "Lme/ahoo/wow/modeling/matedata/StateAggregateMetadata;", "staticTenantId", "", "asMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "isOnCommandFunctionMethod", "", "method", "Ljava/lang/reflect/Method;", "isOnErrorFunctionMethod", "visitMethod", "", "wow-core"})
    @SourceDebugExtension(value={"SMAP\nAggregateMetadataParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AggregateMetadataParser.kt\nme/ahoo/wow/modeling/annotation/AggregateMetadataParser$AggregateMetadataVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 AnnotationScanner.kt\nme/ahoo/wow/infra/reflection/AnnotationScanner\n*L\n1#1,141:1\n11335#2:142\n11670#2,3:143\n288#3,2:146\n73#4,2:148\n73#4,2:150\n*S KotlinDebug\n*F\n+ 1 AggregateMetadataParser.kt\nme/ahoo/wow/modeling/annotation/AggregateMetadataParser$AggregateMetadataVisitor\n*L\n66#1:142\n66#1:143,3\n70#1:146,2\n84#1:148,2\n85#1:150,2\n*E\n"})
    private static final class AggregateMetadataVisitor<C, S>
    implements ClassVisitor {
        @NotNull
        private final Class<C> commandAggregateType;
        @NotNull
        private final StateAggregateMetadata<S> stateAggregateMetadata;
        @Nullable
        private final String staticTenantId;
        @NotNull
        private Constructor<C> constructor;
        @NotNull
        private Map<Class<?>, MethodFunctionMetadata<C, Mono<?>>> commandFunctionRegistry;
        @NotNull
        private Map<Class<?>, MethodFunctionMetadata<C, Mono<?>>> errorFunctionRegistry;

        /*
         * WARNING - void declaration
         */
        public AggregateMetadataVisitor(@NotNull Class<C> commandAggregateType) {
            void this_$iv;
            Object v1;
            AnnotationScanner $this$mapTo$iv$iv;
            block4: {
                void $this$firstOrNull$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNullParameter(commandAggregateType, (String)"commandAggregateType");
                this.commandFunctionRegistry = new HashMap();
                this.errorFunctionRegistry = new HashMap();
                Constructor<?>[] constructorArray = commandAggregateType.getDeclaredConstructors();
                Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"commandAggregateType.declaredConstructors");
                Object[] objectArray = constructorArray;
                AggregateMetadataVisitor aggregateMetadataVisitor = this;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Constructor constructor = (Constructor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type java.lang.reflect.Constructor<C of me.ahoo.wow.modeling.annotation.AggregateMetadataParser.AggregateMetadataVisitor._init_$lambda$0>");
                    collection.add(it);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Constructor it = (Constructor)element$iv;
                    boolean bl = false;
                    if (!(it.getParameterCount() == 1)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            Constructor constructor = v1;
            if (constructor == null) {
                throw new IllegalStateException("Failed to parse CommandAggregate[" + commandAggregateType + "] metadata: Not defined Constructor[ctor(aggregateId) or ctor(stateAggregate)].");
            }
            aggregateMetadataVisitor.constructor = constructor;
            this.commandAggregateType = commandAggregateType;
            Class<?> ctorParameterType = this.constructor.getParameterTypes()[0];
            Class<Object> clazz = !Intrinsics.areEqual(String.class, ctorParameterType) ? ctorParameterType : commandAggregateType;
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<S of me.ahoo.wow.modeling.annotation.AggregateMetadataParser.AggregateMetadataVisitor>");
            Class<Object> stateAggregateType = clazz;
            this.stateAggregateMetadata = StateAggregateMetadataParserKt.asStateAggregateMetadata(stateAggregateType);
            $this$mapTo$iv$iv = AnnotationScanner.INSTANCE;
            AnnotatedElement $this$scan$iv = commandAggregateType;
            boolean $i$f$scan2 = false;
            Class<StaticTenantId> targetAnnotationType$iv = StaticTenantId.class;
            Object object = this_$iv.scan($this$scan$iv, targetAnnotationType$iv);
            if (object == null || (object = object.tenantId()) == null) {
                void this_$iv2;
                AnnotationScanner $i$f$scan2 = AnnotationScanner.INSTANCE;
                AnnotatedElement $this$scan$iv2 = stateAggregateType;
                boolean $i$f$scan3 = false;
                Class<StaticTenantId> targetAnnotationType$iv2 = StaticTenantId.class;
                StaticTenantId staticTenantId = this_$iv2.scan($this$scan$iv2, targetAnnotationType$iv2);
                object = staticTenantId != null ? staticTenantId.tenantId() : null;
            }
            this.staticTenantId = object;
        }

        @Override
        public void visitMethod(@NotNull Method method) {
            MethodFunctionMetadata functionMetadata;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            if (method.isAnnotationPresent(OnCommand.class) || this.isOnCommandFunctionMethod(method)) {
                functionMetadata = MethodFunctionMetadataKt.asMonoFunctionMetadata(method);
                this.commandFunctionRegistry.putIfAbsent(functionMetadata.getSupportedType(), functionMetadata);
            }
            if (method.isAnnotationPresent(OnError.class) || this.isOnErrorFunctionMethod(method)) {
                functionMetadata = MethodFunctionMetadataKt.asMonoFunctionMetadata(method);
                this.errorFunctionRegistry.putIfAbsent(functionMetadata.getSupportedType(), functionMetadata);
            }
        }

        private final boolean isOnCommandFunctionMethod(Method method) {
            return Intrinsics.areEqual((Object)"onCommand", (Object)method.getName()) && method.getParameterCount() > 0 && !Intrinsics.areEqual(method.getReturnType(), Void.TYPE);
        }

        private final boolean isOnErrorFunctionMethod(Method method) {
            return Intrinsics.areEqual((Object)"onError", (Object)method.getName()) && method.getParameterCount() > 0;
        }

        @NotNull
        public final AggregateMetadata<C, S> asMetadata() {
            NamedAggregate namedAggregate;
            if (this.commandFunctionRegistry.isEmpty() && AggregateMetadataParserKt.access$getLog$p().isWarnEnabled()) {
                AggregateMetadataParserKt.access$getLog$p().warn("CommandAggregate[" + this.commandAggregateType + "] requires at least one OnCommand function!");
            }
            if ((namedAggregate = (NamedAggregate)MetadataSearcher.INSTANCE.getTypeNamedAggregate().get((Object)this.commandAggregateType)) == null) {
                boolean $i$a$-checkNotNull-AggregateMetadataParser$AggregateMetadataVisitor$asMetadata$22 = false;
                String $i$a$-checkNotNull-AggregateMetadataParser$AggregateMetadataVisitor$asMetadata$22 = "Failed to parse CommandAggregate[" + this.commandAggregateType + "] metadata: Not defined in the metadata resource file[META-INF/wow-metadata.json].";
                throw new IllegalStateException($i$a$-checkNotNull-AggregateMetadataParser$AggregateMetadataVisitor$asMetadata$22.toString());
            }
            CommandAggregateMetadata<C> commandAggregateMetadata = new CommandAggregateMetadata<C>(this.commandAggregateType, namedAggregate, (ConstructorAccessor)new DefaultConstructorAccessor<C>(this.constructor), this.commandFunctionRegistry, this.errorFunctionRegistry);
            return new AggregateMetadata<C, S>(namedAggregate, this.staticTenantId, this.stateAggregateMetadata, commandAggregateMetadata);
        }
    }
}

