/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.command;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.messaging.Message;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.InMemoryCommandBus;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.configuration.MetadataSearcher;
import me.ahoo.wow.infra.Decorator;
import me.ahoo.wow.metrics.AbstractMetricDecorator;
import me.ahoo.wow.metrics.Metrics;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0001\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\"\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/ahoo/wow/command/LocalFirstCommandBus;", "Lme/ahoo/wow/command/CommandBus;", "distributedCommandBus", "localCommandBus", "localAggregates", "", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "(Lme/ahoo/wow/command/CommandBus;Lme/ahoo/wow/command/CommandBus;Ljava/util/Set;)V", "distributedName", "", "kotlin.jvm.PlatformType", "localName", "receive", "Lreactor/core/publisher/Flux;", "Lme/ahoo/wow/command/ServerCommandExchange;", "", "namedAggregates", "send", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "message", "Lme/ahoo/wow/api/command/CommandMessage;", "wow-core"})
public final class LocalFirstCommandBus
implements CommandBus {
    @NotNull
    private final CommandBus distributedCommandBus;
    @NotNull
    private final CommandBus localCommandBus;
    @NotNull
    private final Set<NamedAggregate> localAggregates;
    private final String localName;
    private final String distributedName;

    public LocalFirstCommandBus(@NotNull CommandBus distributedCommandBus, @NotNull CommandBus localCommandBus, @NotNull Set<? extends NamedAggregate> localAggregates) {
        Intrinsics.checkNotNullParameter((Object)distributedCommandBus, (String)"distributedCommandBus");
        Intrinsics.checkNotNullParameter((Object)localCommandBus, (String)"localCommandBus");
        Intrinsics.checkNotNullParameter(localAggregates, (String)"localAggregates");
        this.distributedCommandBus = distributedCommandBus;
        this.localCommandBus = localCommandBus;
        this.localAggregates = localAggregates;
        this.localName = Decorator.Companion.getDelegate(this.localCommandBus).getClass().getName();
        this.distributedName = Decorator.Companion.getDelegate(this.distributedCommandBus).getClass().getName();
    }

    public /* synthetic */ LocalFirstCommandBus(CommandBus commandBus, CommandBus commandBus2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            commandBus2 = Metrics.INSTANCE.metrizable(new InMemoryCommandBus(null, 1, null));
        }
        if ((n & 4) != 0) {
            set = CollectionsKt.toSet((Iterable)MetadataSearcher.INSTANCE.getNamedAggregateType().keySet());
        }
        this(commandBus, commandBus2, set);
    }

    @Override
    @NotNull
    public Mono<Void> send(@NotNull CommandMessage<?> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (this.localAggregates.contains(MaterializedNamedAggregateKt.materialize((NamedAggregate)message))) {
            Mono<Void> mono = this.localCommandBus.send((Message)message);
            String string = this.localName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localName");
            return AbstractMetricDecorator.Companion.tagSource(mono, string);
        }
        Mono<Void> mono = this.distributedCommandBus.send((Message)message);
        String string = this.distributedName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"distributedName");
        return AbstractMetricDecorator.Companion.tagSource(mono, string);
    }

    @Override
    @NotNull
    public Flux<ServerCommandExchange<Object>> receive(@NotNull Set<? extends NamedAggregate> namedAggregates) {
        Intrinsics.checkNotNullParameter(namedAggregates, (String)"namedAggregates");
        Flux flux = this.localCommandBus.receive(namedAggregates);
        String string = this.localName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localName");
        Flux localFlux = AbstractMetricDecorator.Companion.tagSource(flux, string);
        Flux flux2 = this.distributedCommandBus.receive(namedAggregates);
        String string2 = this.distributedName;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"distributedName");
        Flux distributedFlux = AbstractMetricDecorator.Companion.tagSource(flux2, string2);
        Publisher[] publisherArray = new Publisher[]{localFlux, distributedFlux};
        Flux flux3 = Flux.merge((Publisher[])publisherArray);
        Intrinsics.checkNotNullExpressionValue((Object)flux3, (String)"merge(localFlux, distributedFlux)");
        return flux3;
    }
}

