/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.eventsourcing.snapshot;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.snapshot.SimpleSnapshotStrategy;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lme/ahoo/wow/eventsourcing/snapshot/TimeOffsetSnapshotStrategy;", "Lme/ahoo/wow/eventsourcing/snapshot/SimpleSnapshotStrategy;", "timeOffset", "", "snapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "stateAggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "(JLme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;Lme/ahoo/wow/eventsourcing/EventStore;Lme/ahoo/wow/modeling/state/StateAggregateFactory;)V", "Companion", "wow-core"})
public final class TimeOffsetSnapshotStrategy
extends SimpleSnapshotStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long timeOffset;
    private static final Logger log = LoggerFactory.getLogger(TimeOffsetSnapshotStrategy.class);

    public TimeOffsetSnapshotStrategy(final long timeOffset, @NotNull SnapshotRepository snapshotRepository, @NotNull EventStore eventStore, @NotNull StateAggregateFactory stateAggregateFactory) {
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory, (String)"stateAggregateFactory");
        super((Function2<? super Snapshot<Object>, ? super DomainEventStream, Boolean>)((Function2)new Function2<Snapshot<Object>, DomainEventStream, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull Snapshot<Object> snapshot, @NotNull DomainEventStream eventStream) {
                boolean matched;
                Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
                Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
                long currentTimeOffset = eventStream.getCreateTime() - snapshot.getSnapshotTime();
                boolean bl = matched = currentTimeOffset >= timeOffset;
                if (log.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{eventStream.getAggregateId(), currentTimeOffset, timeOffset, matched};
                    log.debug("[{}] Current time offset:[{}] - expected offset:[{}] matched:[{}].", objectArray);
                }
                return matched;
            }
        }), snapshotRepository, eventStore, stateAggregateFactory);
        this.timeOffset = timeOffset;
    }

    public /* synthetic */ TimeOffsetSnapshotStrategy(long l, SnapshotRepository snapshotRepository, EventStore eventStore, StateAggregateFactory stateAggregateFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            stateAggregateFactory = ConstructorStateAggregateFactory.INSTANCE;
        }
        this(l, snapshotRepository, eventStore, stateAggregateFactory);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/eventsourcing/snapshot/TimeOffsetSnapshotStrategy$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

