/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.modeling.command;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.api.modeling.NamedTypedAggregate;
import me.ahoo.wow.api.naming.NamedBoundedContext;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.messaging.function.MessageFunction;
import me.ahoo.wow.messaging.handler.MessageExchange;
import me.ahoo.wow.modeling.command.CommandAggregate;
import me.ahoo.wow.modeling.command.CommandState;
import me.ahoo.wow.modeling.command.IllegalAccessDeletedAggregateException;
import me.ahoo.wow.modeling.command.IncompatibleVersionException;
import me.ahoo.wow.modeling.command.SimpleCommandAggregate;
import me.ahoo.wow.modeling.matedata.CommandAggregateMetadata;
import me.ahoo.wow.modeling.state.StateAggregate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 3*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005:\u00013B1\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\u0010\rJ\u0011\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0096\u0001J\u0011\u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020/H\u0096\u0001J\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\n\u00101\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\b\u00102\u001a\u00020\u000fH\u0016R\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R:\u0010\u0016\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012 \u0012\u001e\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0012\u0010%\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0011R8\u0010'\u001a,\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00064"}, d2={"Lme/ahoo/wow/modeling/command/SimpleCommandAggregate;", "C", "", "S", "Lme/ahoo/wow/modeling/command/CommandAggregate;", "Lme/ahoo/wow/api/modeling/NamedTypedAggregate;", "state", "Lme/ahoo/wow/modeling/state/StateAggregate;", "commandRoot", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "metadata", "Lme/ahoo/wow/modeling/matedata/CommandAggregateMetadata;", "(Lme/ahoo/wow/modeling/state/StateAggregate;Ljava/lang/Object;Lme/ahoo/wow/eventsourcing/EventStore;Lme/ahoo/wow/modeling/matedata/CommandAggregateMetadata;)V", "aggregateName", "", "getAggregateName", "()Ljava/lang/String;", "aggregateType", "Ljava/lang/Class;", "getAggregateType", "()Ljava/lang/Class;", "commandFunctionRegistry", "", "Lme/ahoo/wow/messaging/function/MessageFunction;", "Lme/ahoo/wow/command/ServerCommandExchange;", "Lreactor/core/publisher/Mono;", "Lme/ahoo/wow/event/DomainEventStream;", "getCommandRoot", "()Ljava/lang/Object;", "Ljava/lang/Object;", "commandState", "Lme/ahoo/wow/modeling/command/CommandState;", "getCommandState", "()Lme/ahoo/wow/modeling/command/CommandState;", "setCommandState", "(Lme/ahoo/wow/modeling/command/CommandState;)V", "contextName", "getContextName", "errorFunctionRegistry", "getState", "()Lme/ahoo/wow/modeling/state/StateAggregate;", "isSameAggregateName", "", "other", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "isSameBoundedContext", "Lme/ahoo/wow/api/naming/NamedBoundedContext;", "process", "exchange", "toString", "Companion", "wow-core"})
public final class SimpleCommandAggregate<C, S>
implements CommandAggregate<C, S>,
NamedTypedAggregate<C> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final StateAggregate<S> state;
    @NotNull
    private final C commandRoot;
    @NotNull
    private final EventStore eventStore;
    @NotNull
    private final CommandAggregateMetadata<C> metadata;
    @NotNull
    private final Map<Class<?>, MessageFunction<C, ServerCommandExchange<?>, Mono<DomainEventStream>>> commandFunctionRegistry;
    @NotNull
    private final Map<Class<?>, MessageFunction<C, ServerCommandExchange<?>, Mono<?>>> errorFunctionRegistry;
    @NotNull
    private volatile CommandState commandState;
    @NotNull
    private static final Logger log;

    public SimpleCommandAggregate(@NotNull StateAggregate<S> state, @NotNull C commandRoot, @NotNull EventStore eventStore, @NotNull CommandAggregateMetadata<C> metadata2) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter(commandRoot, (String)"commandRoot");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter(metadata2, (String)"metadata");
        this.state = state;
        this.commandRoot = commandRoot;
        this.eventStore = eventStore;
        this.metadata = metadata2;
        this.commandFunctionRegistry = this.metadata.asCommandFunctionRegistry(this);
        this.errorFunctionRegistry = this.metadata.asErrorFunctionRegistry(this);
        this.commandState = CommandState.STORED;
    }

    @Override
    @NotNull
    public StateAggregate<S> getState() {
        return this.state;
    }

    @Override
    @NotNull
    public C getCommandRoot() {
        return this.commandRoot;
    }

    @NotNull
    public String getAggregateName() {
        return this.metadata.getAggregateName();
    }

    @NotNull
    public Class<C> getAggregateType() {
        return this.metadata.getAggregateType();
    }

    @NotNull
    public String getContextName() {
        return this.metadata.getContextName();
    }

    public boolean isSameAggregateName(@NotNull NamedAggregate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.metadata.isSameAggregateName(other);
    }

    public boolean isSameBoundedContext(@NotNull NamedBoundedContext other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.metadata.isSameBoundedContext(other);
    }

    @Override
    @NotNull
    public CommandState getCommandState() {
        return this.commandState;
    }

    public void setCommandState(@NotNull CommandState commandState) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandState), (String)"<set-?>");
        this.commandState = commandState;
    }

    @Override
    @NotNull
    public Mono<DomainEventStream> process(@NotNull ServerCommandExchange<?> exchange) {
        Intrinsics.checkNotNullParameter(exchange, (String)"exchange");
        Mono mono = Mono.defer(() -> SimpleCommandAggregate.process$lambda$5(exchange, this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer {\n            val \u2026              }\n        }");
        return mono;
    }

    @NotNull
    public String toString() {
        return "SimpleCommandAggregate(state=" + this.getState() + ", metadata=" + this.metadata + ", commandState=" + (Object)((Object)this.getCommandState()) + ')';
    }

    private static final void process$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Mono process$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono process$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono process$lambda$5(ServerCommandExchange $exchange, SimpleCommandAggregate this$0) {
        Intrinsics.checkNotNullParameter((Object)$exchange, (String)"$exchange");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CommandMessage message = (CommandMessage)$exchange.getMessage();
        if (log.isDebugEnabled()) {
            log.debug("Process {}.", (Object)message);
        }
        if (message.getAggregateVersion() != null) {
            Integer n = message.getAggregateVersion();
            int n2 = this$0.getVersion();
            if (n == null || n != n2) {
                Integer n3 = message.getAggregateVersion();
                Intrinsics.checkNotNull((Object)n3);
                return MonoExtensionsKt.toMono((Throwable)((Throwable)((Object)new IncompatibleVersionException(message, n3, this$0.getVersion()))));
            }
        }
        if (!(message.isCreate() || message.getAllowCreate() || this$0.getInitialized())) {
            return MonoExtensionsKt.toMono((Throwable)new IllegalArgumentException("Failed to process command[" + message.getId() + "]: The current StateAggregate[" + this$0.getAggregateId() + "] is not initialized."));
        }
        if (!(this$0.getCommandState() == CommandState.STORED)) {
            boolean $i$a$-check-SimpleCommandAggregate$process$1$22 = false;
            String $i$a$-check-SimpleCommandAggregate$process$1$22 = "Failed to process command[" + message.getId() + "]: The current StateAggregate[" + this$0.getAggregateId() + "] is not stored.";
            throw new IllegalStateException($i$a$-check-SimpleCommandAggregate$process$1$22.toString());
        }
        if (this$0.getState().getDeleted()) {
            return MonoExtensionsKt.toMono((Throwable)((Throwable)((Object)new IllegalAccessDeletedAggregateException(this$0.getState().getAggregateId()))));
        }
        Class<Object> commandType = message.getBody().getClass();
        MessageFunction commandFunction = this$0.commandFunctionRegistry.get(commandType);
        if (commandFunction == null) {
            boolean bl = false;
            String string = "Failed to process command[" + message.getId() + "]: Undefined command[" + message.getBody().getClass() + "].";
            throw new IllegalArgumentException(string.toString());
        }
        return commandFunction.handle((ServerCommandExchange<?>)((MessageExchange)$exchange)).doOnNext(arg_0 -> SimpleCommandAggregate.process$lambda$5$lambda$2((Function1)new Function1<DomainEventStream, Unit>($exchange, this$0){
            final /* synthetic */ ServerCommandExchange<?> $exchange;
            final /* synthetic */ SimpleCommandAggregate<C, S> this$0;
            {
                this.$exchange = $exchange;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(DomainEventStream it) {
                this.$exchange.setEventStream(it);
                CommandState commandState = this.this$0.getCommandState();
                StateAggregate<S> stateAggregate = this.this$0.getState();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.this$0.setCommandState(commandState.onSourcing(stateAggregate, it));
            }
        }, arg_0)).flatMap(arg_0 -> SimpleCommandAggregate.process$lambda$5$lambda$3((Function1)new Function1<DomainEventStream, Mono<? extends DomainEventStream>>(this$0){
            final /* synthetic */ SimpleCommandAggregate<C, S> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Mono<? extends DomainEventStream> invoke(DomainEventStream eventStream) {
                CommandState commandState = this.this$0.getCommandState();
                EventStore eventStore = SimpleCommandAggregate.access$getEventStore$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)eventStream, (String)"eventStream");
                return commandState.onStore(eventStore, eventStream).doOnNext(arg_0 -> process.1.4.invoke$lambda$0((Function1)new Function1<CommandState, Unit>(this.this$0){
                    final /* synthetic */ SimpleCommandAggregate<C, S> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(CommandState it) {
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)it), (String)"it");
                        this.this$0.setCommandState(it);
                    }
                }, arg_0)).doOnError(arg_0 -> process.1.4.invoke$lambda$1((Function1)new Function1<Throwable, Unit>(this.this$0){
                    final /* synthetic */ SimpleCommandAggregate<C, S> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(Throwable it) {
                        this.this$0.setCommandState(CommandState.EXPIRED);
                    }
                }, arg_0)).thenReturn((Object)eventStream);
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0)).onErrorResume(arg_0 -> SimpleCommandAggregate.process$lambda$5$lambda$4((Function1)new Function1<Throwable, Mono<? extends DomainEventStream>>($exchange, this$0, commandType){
            final /* synthetic */ ServerCommandExchange<?> $exchange;
            final /* synthetic */ SimpleCommandAggregate<C, S> this$0;
            final /* synthetic */ Class<Object> $commandType;
            {
                this.$exchange = $exchange;
                this.this$0 = $receiver;
                this.$commandType = $commandType;
                super(1);
            }

            public final Mono<? extends DomainEventStream> invoke(Throwable it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.$exchange.setError(it);
                MessageFunction errorFunction = (MessageFunction)SimpleCommandAggregate.access$getErrorFunctionRegistry$p(this.this$0).get(this.$commandType);
                Mono mono = Mono.error((Throwable)it);
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error<DomainEventStream>(it)");
                Mono errorMono = mono;
                MessageFunction messageFunction = errorFunction;
                if (messageFunction == null || (messageFunction = (Mono)messageFunction.handle((MessageExchange)this.$exchange)) == null || (messageFunction = messageFunction.then(errorMono)) == null) {
                    messageFunction = errorMono;
                }
                return messageFunction;
            }
        }, arg_0));
    }

    public static final /* synthetic */ EventStore access$getEventStore$p(SimpleCommandAggregate $this) {
        return $this.eventStore;
    }

    public static final /* synthetic */ Map access$getErrorFunctionRegistry$p(SimpleCommandAggregate $this) {
        return $this.errorFunctionRegistry;
    }

    static {
        Logger logger = LoggerFactory.getLogger(SimpleCommandAggregate.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(SimpleCommandAggregate::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/wow/modeling/command/SimpleCommandAggregate$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "wow-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

