/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.infra.idempotency;

import com.google.common.hash.BloomFilter;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.infra.idempotency.IdempotencyChecker;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R(\u0010\t\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \u000b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/ahoo/wow/infra/idempotency/BloomFilterIdempotencyChecker;", "Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "ttl", "Ljava/time/Duration;", "bloomFilterSupplier", "Lkotlin/Function0;", "Lcom/google/common/hash/BloomFilter;", "", "(Ljava/time/Duration;Lkotlin/jvm/functions/Function0;)V", "bloomFilterCache", "Lreactor/core/publisher/Mono;", "kotlin.jvm.PlatformType", "check", "", "element", "Companion", "wow-core"})
public final class BloomFilterIdempotencyChecker
implements IdempotencyChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration ttl;
    @NotNull
    private final Function0<BloomFilter<String>> bloomFilterSupplier;
    @NotNull
    private final Mono<BloomFilter<String>> bloomFilterCache;
    private static final Logger log = LoggerFactory.getLogger(BloomFilterIdempotencyChecker.class);

    public BloomFilterIdempotencyChecker(@NotNull Duration ttl, @NotNull Function0<BloomFilter<String>> bloomFilterSupplier) {
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        Intrinsics.checkNotNullParameter(bloomFilterSupplier, (String)"bloomFilterSupplier");
        this.ttl = ttl;
        this.bloomFilterSupplier = bloomFilterSupplier;
        Mono mono = Mono.fromCallable(() -> BloomFilterIdempotencyChecker.bloomFilterCache$lambda$0(this)).cache(this.ttl);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fromCallable {\n        i\u2026pplier()\n    }.cache(ttl)");
        this.bloomFilterCache = mono;
    }

    @Override
    @NotNull
    public Mono<Boolean> check(@NotNull String element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Mono mono = this.bloomFilterCache.map(arg_0 -> BloomFilterIdempotencyChecker.check$lambda$1((Function1)new Function1<BloomFilter<String>, Boolean>(element){
            final /* synthetic */ String $element;
            {
                this.$element = $element;
                super(1);
            }

            public final Boolean invoke(BloomFilter<String> it) {
                boolean contain = it.mightContain((Object)this.$element);
                if (!contain) {
                    it.put((Object)this.$element);
                }
                return !contain;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"element: String): Mono<B\u2026       !contain\n        }");
        return mono;
    }

    private static final BloomFilter bloomFilterCache$lambda$0(BloomFilterIdempotencyChecker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (log.isInfoEnabled()) {
            log.info("Create new BloomFilter.");
        }
        return (BloomFilter)this$0.bloomFilterSupplier.invoke();
    }

    private static final Boolean check$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/infra/idempotency/BloomFilterIdempotencyChecker$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

