/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.infra.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.infra.reflection.ClassVisitor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J*\u0010\u000b\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J*\u0010\u000f\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0007\u00a8\u0006\u0012"}, d2={"Lme/ahoo/wow/infra/reflection/ClassMetadata;", "", "()V", "visit", "", "T", "type", "Ljava/lang/Class;", "visitor", "Lme/ahoo/wow/infra/reflection/ClassVisitor;", "currentDeclaringClass", "visitField", "fieldConsumer", "Ljava/util/function/Consumer;", "Ljava/lang/reflect/Field;", "visitMethod", "methodConsumer", "Ljava/lang/reflect/Method;", "wow-core"})
public final class ClassMetadata {
    @NotNull
    public static final ClassMetadata INSTANCE = new ClassMetadata();

    private ClassMetadata() {
    }

    @JvmStatic
    public static final <T> void visitField(@NotNull Class<T> type, @NotNull Consumer<Field> fieldConsumer) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(fieldConsumer, (String)"fieldConsumer");
        ClassMetadata.visit(type, new ClassVisitor(fieldConsumer){
            final /* synthetic */ Consumer<Field> $fieldConsumer;
            {
                this.$fieldConsumer = $fieldConsumer;
            }

            public void visitField(@NotNull Field field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                this.$fieldConsumer.accept(field);
            }
        });
    }

    @JvmStatic
    public static final <T> void visitMethod(@NotNull Class<T> type, @NotNull Consumer<Method> methodConsumer) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(methodConsumer, (String)"methodConsumer");
        ClassMetadata.visit(type, new ClassVisitor(methodConsumer){
            final /* synthetic */ Consumer<Method> $methodConsumer;
            {
                this.$methodConsumer = $methodConsumer;
            }

            public void visitMethod(@NotNull Method method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                this.$methodConsumer.accept(method);
            }
        });
    }

    @JvmStatic
    public static final <T> void visit(@NotNull Class<T> type, @NotNull ClassVisitor visitor) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        visitor.start();
        INSTANCE.visit(visitor, type);
        Class<?>[] classArray = type.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"type.interfaces");
        for (Class<?> interfaceType : classArray) {
            Intrinsics.checkNotNullExpressionValue(interfaceType, (String)"interfaceType");
            INSTANCE.visit(visitor, interfaceType);
        }
        for (Class<T> currentDeclaringClass = type.getSuperclass(); !Intrinsics.areEqual(Object.class, currentDeclaringClass) && currentDeclaringClass != null; currentDeclaringClass = currentDeclaringClass.getSuperclass()) {
            INSTANCE.visit(visitor, currentDeclaringClass);
        }
        visitor.end();
    }

    private final void visit(ClassVisitor visitor, Class<?> currentDeclaringClass) {
        int n;
        visitor.visitClass(currentDeclaringClass);
        Field[] fieldArray = currentDeclaringClass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"currentDeclaringClass.declaredFields");
        AccessibleObject[] accessibleObjectArray = fieldArray;
        int n2 = accessibleObjectArray.length;
        for (n = 0; n < n2; ++n) {
            Field declaredField;
            Field field = declaredField = accessibleObjectArray[n];
            Intrinsics.checkNotNull((Object)field);
            visitor.visitField(field);
        }
        Constructor<?>[] constructorArray = currentDeclaringClass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"currentDeclaringClass.declaredConstructors");
        accessibleObjectArray = constructorArray;
        n2 = accessibleObjectArray.length;
        for (n = 0; n < n2; ++n) {
            AccessibleObject declaredConstructor;
            AccessibleObject accessibleObject = declaredConstructor = accessibleObjectArray[n];
            Intrinsics.checkNotNull((Object)accessibleObject);
            visitor.visitConstructor((Constructor<?>)accessibleObject);
        }
        Method[] methodArray = currentDeclaringClass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"currentDeclaringClass.declaredMethods");
        accessibleObjectArray = methodArray;
        n2 = accessibleObjectArray.length;
        for (n = 0; n < n2; ++n) {
            AccessibleObject declaredMethod;
            AccessibleObject accessibleObject = declaredMethod = accessibleObjectArray[n];
            Intrinsics.checkNotNull((Object)accessibleObject);
            visitor.visitMethod((Method)accessibleObject);
        }
    }
}

