/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.infra.accessor.property;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.infra.accessor.field.FieldAccessor;
import me.ahoo.wow.infra.accessor.method.SimpleMethodAccessor;
import me.ahoo.wow.infra.accessor.property.FieldPropertyGetter;
import me.ahoo.wow.infra.accessor.property.FieldPropertySetter;
import me.ahoo.wow.infra.accessor.property.MethodPropertyGetter;
import me.ahoo.wow.infra.accessor.property.MethodPropertySetter;
import me.ahoo.wow.infra.accessor.property.PropertyGetter;
import me.ahoo.wow.infra.accessor.property.PropertySetter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J$\u0010\r\u001a\u0010\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u0010\u0018\u00010\u000e\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u0010*\u00020\u0011J$\u0010\r\u001a\u0010\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u0010\u0018\u00010\u000e\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u0010*\u00020\u0012J\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u0014\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u0010*\u00020\u0011J$\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u0010\u0018\u00010\u0014\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u0010*\u00020\u0012R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/ahoo/wow/infra/accessor/property/PropertyDescriptor;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PROPERTY_GETTER_PREFIX", "", "PROPERTY_SETTER_PREFIX", "capitalize", "fieldName", "toGetterName", "toSetterName", "asPropertySetter", "Lme/ahoo/wow/infra/accessor/property/PropertySetter;", "T", "V", "Ljava/lang/reflect/Field;", "Ljava/lang/reflect/Method;", "toPropertyGetter", "Lme/ahoo/wow/infra/accessor/property/PropertyGetter;", "wow-core"})
public final class PropertyDescriptor {
    @NotNull
    public static final PropertyDescriptor INSTANCE = new PropertyDescriptor();
    private static final Logger LOG = LoggerFactory.getLogger(PropertyDescriptor.class);
    @NotNull
    private static final String PROPERTY_GETTER_PREFIX = "get";
    @NotNull
    private static final String PROPERTY_SETTER_PREFIX = "set";

    private PropertyDescriptor() {
    }

    @NotNull
    public final String capitalize(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        String string = fieldName.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String string3 = fieldName.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string2 + string3;
    }

    @NotNull
    public final String toGetterName(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return PROPERTY_GETTER_PREFIX + this.capitalize(fieldName);
    }

    @NotNull
    public final String toSetterName(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return PROPERTY_SETTER_PREFIX + this.capitalize(fieldName);
    }

    @Nullable
    public final <T, V> PropertyGetter<T, V> toPropertyGetter(@NotNull Method $this$toPropertyGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$toPropertyGetter, (String)"<this>");
        if ($this$toPropertyGetter.getParameterCount() == 0 && !Intrinsics.areEqual($this$toPropertyGetter.getReturnType(), Void.TYPE)) {
            return new MethodPropertyGetter(new SimpleMethodAccessor($this$toPropertyGetter));
        }
        return null;
    }

    @NotNull
    public final <T, V> PropertyGetter<T, V> toPropertyGetter(@NotNull Field $this$toPropertyGetter) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$toPropertyGetter, (String)"<this>");
            String string = $this$toPropertyGetter.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String getterName = this.toGetterName(string);
            try {
                Method getterMethod = $this$toPropertyGetter.getDeclaringClass().getDeclaredMethod(getterName, new Class[0]);
                if (Intrinsics.areEqual(getterMethod.getReturnType(), $this$toPropertyGetter.getType())) {
                    Intrinsics.checkNotNull((Object)getterMethod);
                    PropertyGetter<T, V> propertyGetter = this.toPropertyGetter(getterMethod);
                    if (propertyGetter != null) {
                        PropertyGetter<T, V> it = propertyGetter;
                        boolean bl = false;
                        return it;
                    }
                }
            }
            catch (NoSuchMethodException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("AsPropertyGetter: Getter[" + getterName + "] for field[" + $this$toPropertyGetter + "] not found");
            }
        }
        return new FieldPropertyGetter(new FieldAccessor($this$toPropertyGetter));
    }

    @Nullable
    public final <T, V> PropertySetter<T, V> asPropertySetter(@NotNull Method $this$asPropertySetter) {
        Intrinsics.checkNotNullParameter((Object)$this$asPropertySetter, (String)"<this>");
        if ($this$asPropertySetter.getParameterCount() == 1 && Intrinsics.areEqual($this$asPropertySetter.getReturnType(), Void.TYPE)) {
            return new MethodPropertySetter(new SimpleMethodAccessor($this$asPropertySetter));
        }
        return null;
    }

    @Nullable
    public final <T, V> PropertySetter<T, V> asPropertySetter(@NotNull Field $this$asPropertySetter) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$asPropertySetter, (String)"<this>");
            String string = $this$asPropertySetter.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String setterName = this.toSetterName(string);
            try {
                Object object = new Class[]{$this$asPropertySetter.getType()};
                Method setterMethod = $this$asPropertySetter.getDeclaringClass().getDeclaredMethod(setterName, (Class<?>)object);
                Class<?>[] classArray = setterMethod.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
                if (Intrinsics.areEqual((Object)ArraysKt.first((Object[])classArray), $this$asPropertySetter.getType())) {
                    Intrinsics.checkNotNull((Object)setterMethod);
                    object = this.asPropertySetter(setterMethod);
                    if (object != null) {
                        Object it = object;
                        boolean bl = false;
                        return it;
                    }
                }
            }
            catch (NoSuchMethodException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("AsPropertySetter: Setter[" + setterName + "] for field[" + $this$asPropertySetter + "] not found");
            }
        }
        if (Modifier.isFinal($this$asPropertySetter.getModifiers())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("AsPropertySetter: Field[" + $this$asPropertySetter + "] is Final,can not set value.");
            }
            return null;
        }
        return new FieldPropertySetter(new FieldAccessor($this$asPropertySetter));
    }
}

