/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.serialization.command;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.command.SimpleCommandMessage;
import me.ahoo.wow.infra.TypeNameMapper;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.modeling.MaterializedNamedAggregate;
import me.ahoo.wow.serialization.JsonSerializerKt;
import me.ahoo.wow.serialization.command.CommandRecord;
import me.ahoo.wow.serialization.command.CommandRecordKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/ahoo/wow/serialization/command/CommandJsonDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lme/ahoo/wow/api/command/CommandMessage;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "wow-core"})
public final class CommandJsonDeserializer
extends StdDeserializer<CommandMessage<?>> {
    @NotNull
    public static final CommandJsonDeserializer INSTANCE = new CommandJsonDeserializer();

    private CommandJsonDeserializer() {
        super(CommandMessage.class);
    }

    @NotNull
    public CommandMessage<?> deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        TreeNode treeNode = p.getCodec().readTree(p);
        Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readTree(...)");
        CommandRecord commandRecord = CommandRecordKt.toCommandRecord((ObjectNode)treeNode);
        String contextName = commandRecord.getContextName();
        String aggregateName = commandRecord.getAggregateName();
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.aggregateId(new MaterializedNamedAggregate(contextName, aggregateName), commandRecord.getAggregateId(), commandRecord.getTenantId());
        Class bodyType = TypeNameMapper.INSTANCE.toType(commandRecord.getBodyType());
        return new SimpleCommandMessage(commandRecord.getId(), commandRecord.toMessageHeader(), JsonSerializerKt.toObject(commandRecord.getBody(), bodyType), aggregateId, commandRecord.getRequestId(), commandRecord.getAggregateVersion(), commandRecord.getName(), commandRecord.isCreate(), commandRecord.getAllowCreate(), commandRecord.getCreateTime());
    }
}

